/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.EntityConstraint;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.MetadataResponse;
import com.nhl.link.rest.SimpleResponse;
import com.nhl.link.rest.encoder.EncoderFilter;
import com.nhl.link.rest.encoder.PropertyMetadataEncoder;
import com.nhl.link.rest.meta.LrEntityOverlay;
import com.nhl.link.rest.meta.cayenne.CayenneEntityCompiler;
import com.nhl.link.rest.meta.compiler.LrEntityCompiler;
import com.nhl.link.rest.meta.compiler.PojoEntityCompiler;
import com.nhl.link.rest.meta.parser.IResourceParser;
import com.nhl.link.rest.meta.parser.ResourceParser;
import com.nhl.link.rest.provider.CayenneRuntimeExceptionMapper;
import com.nhl.link.rest.provider.DataResponseWriter;
import com.nhl.link.rest.provider.LinkRestExceptionMapper;
import com.nhl.link.rest.provider.MetadataResponseWriter;
import com.nhl.link.rest.provider.SimpleResponseWriter;
import com.nhl.link.rest.provider.ValidationExceptionMapper;
import com.nhl.link.rest.runtime.DefaultLinkRestService;
import com.nhl.link.rest.runtime.ILinkRestService;
import com.nhl.link.rest.runtime.LinkRestRuntime;
import com.nhl.link.rest.runtime.adapter.LinkRestAdapter;
import com.nhl.link.rest.runtime.cayenne.CayennePersister;
import com.nhl.link.rest.runtime.cayenne.ICayennePersister;
import com.nhl.link.rest.runtime.cayenne.NoCayennePersister;
import com.nhl.link.rest.runtime.cayenne.processor.delete.CayenneDeleteProcessorFactoryProvider;
import com.nhl.link.rest.runtime.cayenne.processor.delete.CayenneDeleteStage;
import com.nhl.link.rest.runtime.cayenne.processor.delete.CayenneDeleteStartStage;
import com.nhl.link.rest.runtime.cayenne.processor.select.CayenneAssembleQueryStage;
import com.nhl.link.rest.runtime.cayenne.processor.select.CayenneFetchDataStage;
import com.nhl.link.rest.runtime.cayenne.processor.select.CayenneSelectProcessorFactoryProvider;
import com.nhl.link.rest.runtime.cayenne.processor.unrelate.CayenneUnrelateDataStoreStage;
import com.nhl.link.rest.runtime.cayenne.processor.unrelate.CayenneUnrelateProcessorFactoryProvider;
import com.nhl.link.rest.runtime.cayenne.processor.unrelate.CayenneUnrelateStartStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneCreateOrUpdateStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneCreateStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneCreatedResponseStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneIdempotentCreateOrUpdateStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneIdempotentFullSyncStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneOkResponseStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateProcessorFactoryFactoryProvider;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateStartStage;
import com.nhl.link.rest.runtime.constraints.ConstraintsHandler;
import com.nhl.link.rest.runtime.constraints.IConstraintsHandler;
import com.nhl.link.rest.runtime.encoder.AttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.EncoderService;
import com.nhl.link.rest.runtime.encoder.IAttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.IEncoderService;
import com.nhl.link.rest.runtime.encoder.IStringConverterFactory;
import com.nhl.link.rest.runtime.encoder.StringConverterFactory;
import com.nhl.link.rest.runtime.executor.UnboundedExecutorServiceProvider;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.jackson.JacksonService;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.listener.ListenerService;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.meta.IResourceMetadataService;
import com.nhl.link.rest.runtime.meta.MetadataService;
import com.nhl.link.rest.runtime.meta.ResourceMetadataService;
import com.nhl.link.rest.runtime.parser.IRequestParser;
import com.nhl.link.rest.runtime.parser.IUpdateParser;
import com.nhl.link.rest.runtime.parser.RequestParser;
import com.nhl.link.rest.runtime.parser.UpdateParser;
import com.nhl.link.rest.runtime.parser.cache.IPathCache;
import com.nhl.link.rest.runtime.parser.cache.PathCache;
import com.nhl.link.rest.runtime.parser.converter.DefaultJsonValueConverterFactory;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import com.nhl.link.rest.runtime.parser.filter.CayenneExpProcessor;
import com.nhl.link.rest.runtime.parser.filter.ExpressionPostProcessor;
import com.nhl.link.rest.runtime.parser.filter.ICayenneExpProcessor;
import com.nhl.link.rest.runtime.parser.filter.IExpressionPostProcessor;
import com.nhl.link.rest.runtime.parser.filter.IKeyValueExpProcessor;
import com.nhl.link.rest.runtime.parser.filter.KeyValueExpProcessor;
import com.nhl.link.rest.runtime.parser.sort.ISortProcessor;
import com.nhl.link.rest.runtime.parser.sort.SortProcessor;
import com.nhl.link.rest.runtime.parser.tree.ITreeProcessor;
import com.nhl.link.rest.runtime.parser.tree.IncludeExcludeProcessor;
import com.nhl.link.rest.runtime.processor.delete.DeleteProcessorFactory;
import com.nhl.link.rest.runtime.processor.meta.CollectMetadataStage;
import com.nhl.link.rest.runtime.processor.meta.MetadataProcessorFactory;
import com.nhl.link.rest.runtime.processor.meta.MetadataProcessorFactoryProvider;
import com.nhl.link.rest.runtime.processor.select.ParseRequestStage;
import com.nhl.link.rest.runtime.processor.select.SelectProcessorFactory;
import com.nhl.link.rest.runtime.processor.select.StartStage;
import com.nhl.link.rest.runtime.processor.unrelate.UnrelateProcessorFactory;
import com.nhl.link.rest.runtime.processor.update.ApplyServerParamsStage;
import com.nhl.link.rest.runtime.processor.update.UpdateProcessorFactoryFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import com.nhl.link.rest.runtime.semantics.RelationshipMapper;
import com.nhl.link.rest.runtime.shutdown.ShutdownManager;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.validation.ValidationException;

public class LinkRestBuilder {
    private ICayennePersister cayenneService;
    private Class<? extends ILinkRestService> linkRestServiceType = DefaultLinkRestService.class;
    private ILinkRestService linkRestService;
    private List<EncoderFilter> encoderFilters;
    private Map<String, LrEntityOverlay> entityOverlays = new HashMap<String, LrEntityOverlay>();
    private Map<Class<?>, Class<?>> exceptionMappers;
    private Collection<LinkRestAdapter> adapters;
    private Map<String, PropertyMetadataEncoder> metadataEncoders;
    private ExecutorService executor;

    public static LinkRestRuntime build(ServerRuntime cayenneRuntime) {
        return LinkRestBuilder.builder(cayenneRuntime).build();
    }

    public static LinkRestBuilder builder(ServerRuntime cayenneRuntime) {
        return new LinkRestBuilder().cayenneRuntime(cayenneRuntime);
    }

    public LinkRestBuilder() {
        this.encoderFilters = new ArrayList<EncoderFilter>();
        this.cayenneService = NoCayennePersister.instance();
        this.exceptionMappers = this.mapDefaultExceptions();
        this.adapters = new ArrayList<LinkRestAdapter>();
        this.metadataEncoders = new HashMap<String, PropertyMetadataEncoder>();
    }

    protected Map<Class<?>, Class<?>> mapDefaultExceptions() {
        HashMap map = new HashMap();
        map.put(CayenneRuntimeException.class, CayenneRuntimeExceptionMapper.class);
        map.put(LinkRestException.class, LinkRestExceptionMapper.class);
        map.put(ValidationException.class, ValidationExceptionMapper.class);
        return map;
    }

    public <E extends Throwable> LinkRestBuilder mapException(Class<? extends ExceptionMapper<E>> mapper) {
        for (Type t : mapper.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || !ExceptionMapper.class.equals((Object)(pt = (ParameterizedType)t).getRawType())) continue;
            Type[] args = pt.getActualTypeArguments();
            this.exceptionMappers.put((Class)args[0], mapper);
            return this;
        }
        throw new IllegalArgumentException("Failed to register ExceptionMapper: " + mapper.getName());
    }

    public LinkRestBuilder linkRestService(ILinkRestService linkRestService) {
        this.linkRestService = linkRestService;
        this.linkRestServiceType = null;
        return this;
    }

    public LinkRestBuilder linkRestService(Class<? extends ILinkRestService> linkRestServiceType) {
        this.linkRestService = null;
        this.linkRestServiceType = linkRestServiceType;
        return this;
    }

    public LinkRestBuilder cayenneRuntime(ServerRuntime cayenneRuntime) {
        this.cayenneService = new CayennePersister(cayenneRuntime);
        return this;
    }

    public LinkRestBuilder cayenneService(ICayennePersister cayenneService) {
        this.cayenneService = cayenneService;
        return this;
    }

    public LinkRestBuilder encoderFilter(EncoderFilter filter) {
        this.encoderFilters.add(filter);
        return this;
    }

    public LinkRestBuilder encoderFilters(Collection<EncoderFilter> filters) {
        this.encoderFilters.addAll(filters);
        return this;
    }

    public LinkRestBuilder executor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public LinkRestBuilder transientProperty(Class<?> type, String propertyName) {
        LrEntityOverlay overlay = this.entityOverlays.get(type.getName());
        if (overlay == null) {
            overlay = new LrEntityOverlay(type);
            this.entityOverlays.put(type.getName(), overlay);
        }
        overlay.getTransientAttributes().add(propertyName);
        return this;
    }

    public LinkRestBuilder adapter(LinkRestAdapter adapter) {
        this.adapters.add(adapter);
        return this;
    }

    public LinkRestBuilder metadataEncoder(String type, PropertyMetadataEncoder encoder) {
        this.metadataEncoders.put(type, encoder);
        return this;
    }

    public LinkRestRuntime build() {
        Injector i = this.createInjector();
        return new LinkRestRuntime(i, this.createExtraFeatures(), this.createExtraComponents());
    }

    private Collection<Class<?>> createExtraComponents() {
        return this.exceptionMappers.values();
    }

    private Collection<Feature> createExtraFeatures() {
        if (this.adapters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Feature> features = new ArrayList<Feature>(this.adapters.size());
        for (LinkRestAdapter a : this.adapters) {
            a.contributeToJaxRs(features);
        }
        return features;
    }

    private Injector createInjector() {
        if (this.linkRestService == null && this.linkRestServiceType == null) {
            throw new IllegalStateException("Required 'linkRestService' is not set");
        }
        Module module = binder -> {
            binder.bindList(EncoderFilter.class).addAll(this.encoderFilters);
            binder.bind(CayenneEntityCompiler.class).to(CayenneEntityCompiler.class);
            binder.bind(PojoEntityCompiler.class).to(PojoEntityCompiler.class);
            binder.bindList(LrEntityCompiler.class).add(CayenneEntityCompiler.class).add(PojoEntityCompiler.class);
            binder.bindMap(LrEntityOverlay.class).putAll(this.entityOverlays);
            binder.bindMap(Class.class, "linkrest.jaxrs.bodywriters").put(SimpleResponse.class.getName(), SimpleResponseWriter.class).put(DataResponse.class.getName(), DataResponseWriter.class).put(MetadataResponse.class.getName(), MetadataResponseWriter.class);
            binder.bindList(EntityConstraint.class, "linkrest.constraints.read.list");
            binder.bindList(EntityConstraint.class, "linkrest.constraints.write.list");
            binder.bindMap(PropertyMetadataEncoder.class).putAll(this.metadataEncoders);
            if (this.linkRestServiceType != null) {
                binder.bind(ILinkRestService.class).to(this.linkRestServiceType);
            } else {
                binder.bind(ILinkRestService.class).toInstance((Object)this.linkRestService);
            }
            binder.bind(SelectProcessorFactory.class).toProvider(CayenneSelectProcessorFactoryProvider.class);
            binder.bind(StartStage.class).to(StartStage.class);
            binder.bind(ParseRequestStage.class).to(ParseRequestStage.class);
            binder.bind(com.nhl.link.rest.runtime.processor.select.ApplyServerParamsStage.class).to(com.nhl.link.rest.runtime.processor.select.ApplyServerParamsStage.class);
            binder.bind(CayenneAssembleQueryStage.class).to(CayenneAssembleQueryStage.class);
            binder.bind(CayenneFetchDataStage.class).to(CayenneFetchDataStage.class);
            binder.bind(DeleteProcessorFactory.class).toProvider(CayenneDeleteProcessorFactoryProvider.class);
            binder.bind(CayenneDeleteStartStage.class).to(CayenneDeleteStartStage.class);
            binder.bind(CayenneDeleteStage.class).to(CayenneDeleteStage.class);
            binder.bind(UpdateProcessorFactoryFactory.class).toProvider(CayenneUpdateProcessorFactoryFactoryProvider.class);
            binder.bind(CayenneUpdateStartStage.class).to(CayenneUpdateStartStage.class);
            binder.bind(com.nhl.link.rest.runtime.processor.update.ParseRequestStage.class).to(com.nhl.link.rest.runtime.processor.update.ParseRequestStage.class);
            binder.bind(ApplyServerParamsStage.class).to(ApplyServerParamsStage.class);
            binder.bind(CayenneCreateStage.class).to(CayenneCreateStage.class);
            binder.bind(CayenneUpdateStage.class).to(CayenneUpdateStage.class);
            binder.bind(CayenneCreateOrUpdateStage.class).to(CayenneCreateOrUpdateStage.class);
            binder.bind(CayenneIdempotentCreateOrUpdateStage.class).to(CayenneIdempotentCreateOrUpdateStage.class);
            binder.bind(CayenneIdempotentFullSyncStage.class).to(CayenneIdempotentFullSyncStage.class);
            binder.bind(CayenneOkResponseStage.class).to(CayenneOkResponseStage.class);
            binder.bind(CayenneCreatedResponseStage.class).to(CayenneCreatedResponseStage.class);
            binder.bind(MetadataProcessorFactory.class).toProvider(MetadataProcessorFactoryProvider.class);
            binder.bind(CollectMetadataStage.class).to(CollectMetadataStage.class);
            binder.bind(UnrelateProcessorFactory.class).toProvider(CayenneUnrelateProcessorFactoryProvider.class);
            binder.bind(CayenneUnrelateStartStage.class).to(CayenneUnrelateStartStage.class);
            binder.bind(CayenneUnrelateDataStoreStage.class).to(CayenneUnrelateDataStoreStage.class);
            binder.bind(IRequestParser.class).to(RequestParser.class);
            binder.bind(IJsonValueConverterFactory.class).to(DefaultJsonValueConverterFactory.class);
            binder.bind(IAttributeEncoderFactory.class).to(AttributeEncoderFactory.class);
            binder.bind(IStringConverterFactory.class).to(StringConverterFactory.class);
            binder.bind(IEncoderService.class).to(EncoderService.class);
            binder.bind(IRelationshipMapper.class).to(RelationshipMapper.class);
            binder.bind(IMetadataService.class).to(MetadataService.class);
            binder.bind(IListenerService.class).to(ListenerService.class);
            binder.bind(IResourceMetadataService.class).to(ResourceMetadataService.class);
            binder.bind(IConstraintsHandler.class).to(ConstraintsHandler.class);
            binder.bind(ICayenneExpProcessor.class).to(CayenneExpProcessor.class);
            binder.bind(IExpressionPostProcessor.class).to(ExpressionPostProcessor.class);
            binder.bind(IKeyValueExpProcessor.class).to(KeyValueExpProcessor.class);
            binder.bind(IJacksonService.class).to(JacksonService.class);
            binder.bind(ICayennePersister.class).toInstance((Object)this.cayenneService);
            binder.bind(IPathCache.class).to(PathCache.class);
            binder.bind(ISortProcessor.class).to(SortProcessor.class);
            binder.bind(ITreeProcessor.class).to(IncludeExcludeProcessor.class);
            binder.bind(IResourceParser.class).to(ResourceParser.class);
            binder.bind(IUpdateParser.class).to(UpdateParser.class);
            binder.bind(ShutdownManager.class).toInstance((Object)new ShutdownManager(Duration.ofSeconds(10L)));
            if (this.executor != null) {
                binder.bind(ExecutorService.class).toInstance((Object)this.executor);
            } else {
                binder.bind(ExecutorService.class).toProvider(UnboundedExecutorServiceProvider.class);
            }
            for (LinkRestAdapter a : this.adapters) {
                a.contributeToRuntime(binder);
            }
        };
        return DIBootstrap.createInjector((Module[])new Module[]{module});
    }
}

