/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ObjectMapperFactory;
import com.nhl.link.rest.SimpleResponse;
import com.nhl.link.rest.UpdateBuilder;
import com.nhl.link.rest.UpdateStage;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.runtime.cayenne.ByKeyObjectMapperFactory;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.listener.UpdateListenersBuilder;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import com.nhl.link.rest.runtime.processor.update.UpdateProcessorFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cayenne.exp.Property;

public class DefaultUpdateBuilder<T>
implements UpdateBuilder<T> {
    private UpdateContext<T> context;
    private UpdateListenersBuilder listenersBuilder;
    protected UpdateProcessorFactory processorFactory;
    protected EnumMap<UpdateStage, Processor<UpdateContext<?>>> processors;

    public DefaultUpdateBuilder(UpdateContext<T> context, UpdateProcessorFactory processorFactory, IListenerService listenerService) {
        this.context = context;
        this.listenersBuilder = new UpdateListenersBuilder(this, listenerService, context);
        this.processorFactory = processorFactory;
        this.processors = new EnumMap(UpdateStage.class);
    }

    @Override
    public UpdateBuilder<T> uri(UriInfo uriInfo) {
        this.context.setUriInfo(uriInfo);
        return this;
    }

    @Override
    public UpdateBuilder<T> id(Object id) {
        this.context.setId(id);
        return this;
    }

    @Override
    public UpdateBuilder<T> id(Map<String, Object> ids) {
        for (Map.Entry<String, Object> id : ids.entrySet()) {
            if (id != null) continue;
            throw new LinkRestException(Response.Status.NOT_FOUND, "Part of compound ID is null");
        }
        this.context.setCompoundId(ids);
        return this;
    }

    @Override
    public UpdateBuilder<T> parent(Class<?> parentType, Object parentId, Property<T> relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentId, relationshipFromParent.getName()));
        return this;
    }

    @Override
    public UpdateBuilder<T> parent(Class<?> parentType, Map<String, Object> parentIds, Property<T> relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentIds, relationshipFromParent.getName()));
        return this;
    }

    @Override
    public UpdateBuilder<T> parent(Class<?> parentType, Object parentId, String relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentId, relationshipFromParent));
        return this;
    }

    @Override
    public UpdateBuilder<T> parent(Class<?> parentType, Map<String, Object> parentIds, String relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentIds, relationshipFromParent));
        return this;
    }

    @Override
    public UpdateBuilder<T> toManyParent(Class<?> parentType, Object parentId, Property<? extends Collection<T>> relationshipFromParent) {
        return this.parent(parentType, parentId, relationshipFromParent.getName());
    }

    @Override
    public UpdateBuilder<T> toManyParent(Class<?> parentType, Map<String, Object> parentIds, Property<? extends Collection<T>> relationshipFromParent) {
        return this.parent(parentType, parentIds, relationshipFromParent.getName());
    }

    @Override
    public UpdateBuilder<T> readConstraint(Constraint<T> constraint) {
        this.context.setReadConstraints(constraint);
        return this;
    }

    @Override
    public UpdateBuilder<T> writeConstraint(Constraint<T> constraint) {
        this.context.setWriteConstraints(constraint);
        return this;
    }

    @Override
    public UpdateBuilder<T> mapper(ObjectMapperFactory mapper) {
        this.context.setMapper(mapper);
        return this;
    }

    @Override
    public UpdateBuilder<T> mapper(Property<?> property) {
        return this.mapper(ByKeyObjectMapperFactory.byKey(property));
    }

    @Override
    public UpdateBuilder<T> mapper(String propertyName) {
        return this.mapper(ByKeyObjectMapperFactory.byKey(propertyName));
    }

    @Override
    @Deprecated
    public UpdateBuilder<T> listener(Object listener) {
        this.listenersBuilder.addListener(listener);
        return this;
    }

    @Override
    public <U> UpdateBuilder<T> routingStage(UpdateStage afterStage, Processor<UpdateContext<U>> customStage) {
        return this.routingStage_NoGenerics(afterStage, customStage);
    }

    private <U> UpdateBuilder<T> routingStage_NoGenerics(UpdateStage afterStage, Processor customStage) {
        this.processors.compute(afterStage, (s, existing) -> existing != null ? existing.andThen(customStage) : customStage);
        return this;
    }

    @Override
    public SimpleResponse sync(String entityData) {
        this.context.setEntityData(entityData);
        return this.doSync();
    }

    @Override
    public SimpleResponse sync(EntityUpdate<T> update) {
        return this.sync(Collections.singleton(update));
    }

    @Override
    public SimpleResponse sync(Collection<EntityUpdate<T>> updates) {
        this.context.setUpdates(updates);
        return this.doSync();
    }

    @Override
    public DataResponse<T> syncAndSelect(String entityData) {
        this.context.setEntityData(entityData);
        return this.doSyncAndSelect();
    }

    @Override
    public DataResponse<T> syncAndSelect(Collection<EntityUpdate<T>> updates) {
        this.context.setUpdates(updates);
        return this.doSyncAndSelect();
    }

    @Override
    public DataResponse<T> syncAndSelect(EntityUpdate<T> update) {
        return this.syncAndSelect(Collections.singleton(update));
    }

    private SimpleResponse doSync() {
        this.context.setIncludingDataInResponse(false);
        this.processorFactory.createProcessor(this.processors).execute(this.context);
        return this.context.createSimpleResponse();
    }

    private DataResponse<T> doSyncAndSelect() {
        this.context.setIncludingDataInResponse(true);
        this.processorFactory.createProcessor(this.processors).execute(this.context);
        return this.context.createDataResponse();
    }
}

