/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.SelectBuilder;
import com.nhl.link.rest.SelectStage;
import com.nhl.link.rest.SizeConstraints;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.property.PropertyBuilder;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.listener.SelectListenersBuilder;
import com.nhl.link.rest.runtime.processor.select.SelectContext;
import com.nhl.link.rest.runtime.processor.select.SelectProcessorFactory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cayenne.exp.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSelectBuilder<T>
implements SelectBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSelectBuilder.class);
    protected SelectContext<T> context;
    protected SelectProcessorFactory processorFactory;
    protected SelectListenersBuilder listenersBuilder;
    protected EnumMap<SelectStage, Processor<SelectContext<?>>> processors;

    public DefaultSelectBuilder(SelectContext<T> context, SelectProcessorFactory processorFactory, IListenerService listenerService) {
        this.context = context;
        this.processorFactory = processorFactory;
        this.listenersBuilder = new SelectListenersBuilder(this, listenerService, context);
        this.processors = new EnumMap(SelectStage.class);
    }

    public SelectContext<T> getContext() {
        return this.context;
    }

    @Override
    public SelectBuilder<T> parent(Class<?> parentType, Object parentId, Property<T> relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentId, relationshipFromParent.getName()));
        return this;
    }

    @Override
    public SelectBuilder<T> parent(Class<?> parentType, Map<String, Object> parentIds, Property<T> relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentIds, relationshipFromParent.getName()));
        return this;
    }

    @Override
    public SelectBuilder<T> parent(Class<?> parentType, Object parentId, String relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentId, relationshipFromParent));
        return this;
    }

    @Override
    public SelectBuilder<T> parent(Class<?> parentType, Map<String, Object> parentIds, String relationshipFromParent) {
        this.context.setParent(new EntityParent(parentType, parentIds, relationshipFromParent));
        return this;
    }

    @Override
    public SelectBuilder<T> parent(EntityParent<?> parent) {
        this.context.setParent(parent);
        return this;
    }

    @Override
    public SelectBuilder<T> toManyParent(Class<?> parentType, Object parentId, Property<? extends Collection<T>> relationshipFromParent) {
        return this.parent(parentType, parentId, relationshipFromParent.getName());
    }

    @Override
    public SelectBuilder<T> toManyParent(Class<?> parentType, Map<String, Object> parentIds, Property<? extends Collection<T>> relationshipFromParent) {
        return this.parent(parentType, parentIds, relationshipFromParent.getName());
    }

    @Override
    public SelectBuilder<T> constraint(Constraint<T> constraint) {
        this.context.setConstraint(constraint);
        return this;
    }

    @Override
    public SelectBuilder<T> fetchLimit(int limit) {
        this.getOrCreateSizeConstraints().fetchLimit(limit);
        return this;
    }

    @Override
    public SelectBuilder<T> fetchOffset(int offset) {
        this.getOrCreateSizeConstraints().fetchOffset(offset);
        return this;
    }

    private SizeConstraints getOrCreateSizeConstraints() {
        if (this.context.getSizeConstraints() == null) {
            this.context.setSizeConstraints(new SizeConstraints());
        }
        return this.context.getSizeConstraints();
    }

    @Override
    public SelectBuilder<T> uri(UriInfo uriInfo) {
        this.context.setUriInfo(uriInfo);
        return this;
    }

    @Override
    public SelectBuilder<T> dataEncoder(Encoder encoder) {
        this.context.setEncoder(encoder);
        return this;
    }

    @Override
    public SelectBuilder<T> autocompleteOn(Property<?> autocompleteProperty) {
        this.context.setAutocompleteProperty(autocompleteProperty != null ? autocompleteProperty.getName() : null);
        return this;
    }

    @Override
    public SelectBuilder<T> property(String name) {
        return this.property(name, PropertyBuilder.property());
    }

    @Override
    public SelectBuilder<T> property(String name, EntityProperty clientProperty) {
        EntityProperty oldProperty;
        if (this.context.getExtraProperties() == null) {
            this.context.setExtraProperties(new HashMap<String, EntityProperty>());
        }
        if ((oldProperty = this.context.getExtraProperties().put(name, clientProperty)) != null) {
            logger.info("Overriding existing custom property '" + name + "', ignoring...");
        }
        return this;
    }

    @Override
    public SelectBuilder<T> byId(Object id) {
        if (id == null) {
            throw new LinkRestException(Response.Status.NOT_FOUND, "Null 'id'");
        }
        this.context.setId(id);
        return this;
    }

    @Override
    public SelectBuilder<T> byId(Map<String, Object> ids) {
        for (Map.Entry<String, Object> id : ids.entrySet()) {
            if (id != null) continue;
            throw new LinkRestException(Response.Status.NOT_FOUND, "Part of compound ID is null");
        }
        this.context.setCompoundId(ids);
        return this;
    }

    @Override
    public SelectBuilder<T> listener(Object listener) {
        this.listenersBuilder.addListener(listener);
        return this;
    }

    @Override
    public <U> SelectBuilder<T> routingStage(SelectStage afterStage, Processor<SelectContext<U>> customStage) {
        return this.routingStage_NoGenerics(afterStage, customStage);
    }

    private SelectBuilder<T> routingStage_NoGenerics(SelectStage afterStage, Processor customStage) {
        this.processors.compute(afterStage, (s, existing) -> existing != null ? existing.andThen(customStage) : customStage);
        return this;
    }

    @Override
    public DataResponse<T> get() {
        this.context.setAtMostOneObject(this.context.isById());
        this.processorFactory.createProcessor(this.processors).execute(this.context);
        return this.context.createDataResponse();
    }

    @Override
    public DataResponse<T> getOne() {
        this.context.setAtMostOneObject(true);
        this.processorFactory.createProcessor(this.processors).execute(this.context);
        return this.context.createDataResponse();
    }
}

