/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.DeleteBuilder;
import com.nhl.link.rest.EntityDelete;
import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.MetadataBuilder;
import com.nhl.link.rest.SelectBuilder;
import com.nhl.link.rest.SimpleResponse;
import com.nhl.link.rest.UpdateBuilder;
import com.nhl.link.rest.runtime.DefaultDeleteBuilder;
import com.nhl.link.rest.runtime.DefaultMetadataBuilder;
import com.nhl.link.rest.runtime.DefaultSelectBuilder;
import com.nhl.link.rest.runtime.DefaultUpdateBuilder;
import com.nhl.link.rest.runtime.ILinkRestService;
import com.nhl.link.rest.runtime.UpdateOperation;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.processor.delete.DeleteContext;
import com.nhl.link.rest.runtime.processor.delete.DeleteProcessorFactory;
import com.nhl.link.rest.runtime.processor.meta.MetadataContext;
import com.nhl.link.rest.runtime.processor.meta.MetadataProcessorFactory;
import com.nhl.link.rest.runtime.processor.select.SelectContext;
import com.nhl.link.rest.runtime.processor.select.SelectProcessorFactory;
import com.nhl.link.rest.runtime.processor.unrelate.UnrelateContext;
import com.nhl.link.rest.runtime.processor.unrelate.UnrelateProcessorFactory;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import com.nhl.link.rest.runtime.processor.update.UpdateProcessorFactoryFactory;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Property;

public class DefaultLinkRestService
implements ILinkRestService {
    private IListenerService listenerService;
    private SelectProcessorFactory selectProcessorFactory;
    private DeleteProcessorFactory deleteProcessorFactory;
    private UpdateProcessorFactoryFactory updateProcessorFactoryFactory;
    private MetadataProcessorFactory metadataProcessorFactory;
    private UnrelateProcessorFactory unrelateProcessorFactory;

    public DefaultLinkRestService(@Inject SelectProcessorFactory selectProcessorFactory, @Inject DeleteProcessorFactory deleteProcessorFactory, @Inject UpdateProcessorFactoryFactory updateProcessorFactoryFactory, @Inject MetadataProcessorFactory metadataProcessorFactory, @Inject UnrelateProcessorFactory unrelateProcessorFactory, @Inject IListenerService listenerService) {
        this.selectProcessorFactory = selectProcessorFactory;
        this.deleteProcessorFactory = deleteProcessorFactory;
        this.updateProcessorFactoryFactory = updateProcessorFactoryFactory;
        this.metadataProcessorFactory = metadataProcessorFactory;
        this.unrelateProcessorFactory = unrelateProcessorFactory;
        this.listenerService = listenerService;
    }

    @Override
    public <T> DataResponse<T> selectById(Class<T> root, Object id) {
        return this.select(root).byId(id).get();
    }

    @Override
    public <T> DataResponse<T> selectById(Class<T> root, Object id, UriInfo uriInfo) {
        return this.select(root).uri(uriInfo).byId(id).get();
    }

    @Override
    public <T> SelectBuilder<T> select(Class<T> type) {
        SelectContext<T> context = new SelectContext<T>(type);
        return this.toSelectBuilder(context);
    }

    private <T> SelectBuilder<T> toSelectBuilder(SelectContext<T> context) {
        return new DefaultSelectBuilder<T>(context, this.selectProcessorFactory, this.listenerService);
    }

    @Override
    public SimpleResponse unrelate(Class<?> type, Object sourceId, Property<?> relationship) {
        return this.unrelate(type, sourceId, relationship.getName());
    }

    @Override
    public <T> SimpleResponse unrelate(Class<T> type, Object sourceId, String relationship) {
        UnrelateContext<T> context = new UnrelateContext<T>(type, new EntityParent<T>(type, sourceId, relationship));
        this.unrelateProcessorFactory.createProcessor().execute(context);
        return context.createSimpleResponse();
    }

    @Override
    public SimpleResponse unrelate(Class<?> type, Object sourceId, Property<?> relationship, Object targetId) {
        return this.unrelate(type, sourceId, relationship.getName(), targetId);
    }

    @Override
    public <T> SimpleResponse unrelate(Class<T> type, Object sourceId, String relationship, Object targetId) {
        UnrelateContext<T> context = new UnrelateContext<T>(type, new EntityParent<T>(type, sourceId, relationship), targetId);
        this.unrelateProcessorFactory.createProcessor().execute(context);
        return context.createSimpleResponse();
    }

    @Override
    public SimpleResponse delete(Class<?> root, Object id) {
        return this.delete(root).id(id).delete();
    }

    @Override
    public SimpleResponse delete(Class<?> root, Map<String, Object> ids) {
        return this.delete(root).id(ids).delete();
    }

    @Override
    public <T> SimpleResponse delete(Class<T> root, Collection<EntityDelete<T>> deleted) {
        DeleteBuilder builder = this.delete(root);
        deleted.forEach(entityDelete -> builder.id(entityDelete.getId()));
        return builder.delete();
    }

    @Override
    public <T> UpdateBuilder<T> create(Class<T> type) {
        UpdateContext<T> context = new UpdateContext<T>(type);
        return new DefaultUpdateBuilder<T>(context, this.updateProcessorFactoryFactory.getFactory(UpdateOperation.create), this.listenerService);
    }

    @Override
    public <T> UpdateBuilder<T> createOrUpdate(Class<T> type) {
        UpdateContext<T> context = new UpdateContext<T>(type);
        return new DefaultUpdateBuilder<T>(context, this.updateProcessorFactoryFactory.getFactory(UpdateOperation.createOrUpdate), this.listenerService);
    }

    @Override
    public <T> UpdateBuilder<T> idempotentCreateOrUpdate(Class<T> type) {
        UpdateContext<T> context = new UpdateContext<T>(type);
        return new DefaultUpdateBuilder<T>(context, this.updateProcessorFactoryFactory.getFactory(UpdateOperation.idempotentCreateOrUpdate), this.listenerService);
    }

    @Override
    public <T> UpdateBuilder<T> idempotentFullSync(Class<T> type) {
        UpdateContext<T> context = new UpdateContext<T>(type);
        return new DefaultUpdateBuilder<T>(context, this.updateProcessorFactoryFactory.getFactory(UpdateOperation.idempotentFullSync), this.listenerService);
    }

    @Override
    public <T> UpdateBuilder<T> update(Class<T> type) {
        UpdateContext<T> context = new UpdateContext<T>(type);
        return new DefaultUpdateBuilder<T>(context, this.updateProcessorFactoryFactory.getFactory(UpdateOperation.update), this.listenerService);
    }

    @Override
    public <T> DeleteBuilder<T> delete(Class<T> type) {
        DeleteContext<T> context = new DeleteContext<T>(type);
        return new DefaultDeleteBuilder<T>(context, this.deleteProcessorFactory);
    }

    @Override
    public <T> MetadataBuilder<T> metadata(Class<T> type) {
        MetadataContext<T> context = new MetadataContext<T>(type);
        return new DefaultMetadataBuilder<T>(context, this.metadataProcessorFactory);
    }
}

