/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.provider;

import com.nhl.link.rest.SimpleResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExceptionMapper.class);
    private static final String ERROR_MESSAGE_EN = "Object validation failed. There were %s failure(s).";

    public Response toResponse(ValidationException exception) {
        ValidationResult validation = exception.getValidationResult();
        Response.Status status = Response.Status.BAD_REQUEST;
        if (LOGGER.isInfoEnabled()) {
            StringBuilder log = new StringBuilder();
            log.append(status.getStatusCode()).append(" ").append(status.getReasonPhrase());
            log.append(" (").append(validation).append(")");
            LOGGER.info(log.toString());
        }
        String message = String.format(ERROR_MESSAGE_EN, validation.getFailures().size());
        SimpleResponse body = new SimpleResponse(false, message);
        return Response.status((Response.Status)status).entity((Object)body).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

