/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.provider;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.SimpleResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LinkRestExceptionMapper
implements ExceptionMapper<LinkRestException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkRestExceptionMapper.class);

    public Response toResponse(LinkRestException exception) {
        String message = exception.getMessage();
        String causeMessage = exception.getCause() != null && exception.getCause() != exception ? exception.getCause().getMessage() : null;
        Response.Status status = exception.getStatus();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder log = new StringBuilder();
            log.append(status.getStatusCode()).append(" ").append(status.getReasonPhrase());
            if (message != null) {
                log.append(" (").append(message).append(")");
            }
            if (causeMessage != null) {
                log.append(" [cause: ").append(causeMessage).append("]");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(log.toString(), (Throwable)exception);
            } else {
                LOGGER.info(log.toString());
            }
        }
        SimpleResponse body = new SimpleResponse(false, message);
        return Response.status((Response.Status)status).entity((Object)body).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

