/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.provider;

import com.nhl.link.rest.SimpleResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CayenneRuntimeExceptionMapper
implements ExceptionMapper<CayenneRuntimeException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CayenneRuntimeExceptionMapper.class);

    public Response toResponse(CayenneRuntimeException ex) {
        LOGGER.warn("Cayenne exception", (Throwable)ex);
        Throwable cause = Util.unwindException((Throwable)ex);
        String message = cause.getMessage();
        if (message == null) {
            message = "";
        }
        if (message.length() > 300) {
            message = message.substring(0, 300) + "...";
        }
        message = "CayenneRuntimeException " + message;
        SimpleResponse body = new SimpleResponse(false, message);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)body).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

