/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderVisitor;
import com.nhl.link.rest.encoder.GenericEncoder;
import com.nhl.link.rest.property.BeanPropertyReader;
import com.nhl.link.rest.property.DataObjectPropertyReader;
import com.nhl.link.rest.property.PropertyReader;
import java.io.IOException;

public class PropertyBuilder
implements EntityProperty {
    private static final EntityProperty DO_NOTHING_PROPERTY = new EntityProperty(){

        @Override
        public void encode(Object root, String propertyName, JsonGenerator out) throws IOException {
        }

        @Override
        public Object read(Object root, String propertyName) {
            throw new UnsupportedOperationException("Can't read property: " + propertyName);
        }

        @Override
        public int visit(Object root, String propertyName, EncoderVisitor visitor) {
            return 0;
        }
    };
    private Encoder encoder;
    private PropertyReader reader;

    public static EntityProperty doNothingProperty() {
        return DO_NOTHING_PROPERTY;
    }

    public static PropertyBuilder property() {
        return new PropertyBuilder(BeanPropertyReader.reader(), GenericEncoder.encoder());
    }

    public static PropertyBuilder property(PropertyReader reader) {
        return new PropertyBuilder(reader, GenericEncoder.encoder());
    }

    public static PropertyBuilder dataObjectProperty() {
        return PropertyBuilder.property(DataObjectPropertyReader.reader());
    }

    private PropertyBuilder(PropertyReader reader, Encoder encoder) {
        this.encoder = encoder;
        this.reader = reader;
    }

    public PropertyBuilder encodedWith(Encoder encoder) {
        this.encoder = encoder;
        return this;
    }

    @Override
    public void encode(Object root, String propertyName, JsonGenerator out) throws IOException {
        Object value = root == null ? null : this.read(root, propertyName);
        this.encoder.encode(propertyName, value, out);
    }

    @Override
    public Object read(Object root, String propertyName) {
        return this.reader.value(root, propertyName);
    }

    @Override
    public int visit(Object root, String propertyName, EncoderVisitor visitor) {
        Object value = root == null ? null : this.read(root, propertyName);
        return this.encoder.visitEntities(value, visitor);
    }
}

