/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.property;

import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentEntity;
import com.nhl.link.rest.property.BeanPropertyReader;
import com.nhl.link.rest.property.DataObjectPropertyReader;
import com.nhl.link.rest.property.PersistentObjectIdPropertyReader;
import com.nhl.link.rest.property.PropertyReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class IdPropertyReader
implements PropertyReader {
    private LrEntity<?> entity;
    private boolean isPersistent;

    public IdPropertyReader(LrEntity<?> entity) {
        this.entity = entity;
        this.isPersistent = entity instanceof LrPersistentEntity;
    }

    @Override
    public Object value(Object root, String name) {
        Collection<LrAttribute> ids = this.entity.getIds();
        if (ids.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>((int)((double)ids.size() / 0.75) + 1);
        for (LrAttribute id : ids) {
            idMap.put(id.getName(), this.readPropertyOrId(root, id.getName()));
        }
        return idMap;
    }

    private Object readPropertyOrId(Object object, String name) {
        if (this.isPersistent) {
            Object property = DataObjectPropertyReader.reader().value(object, name);
            return property == null ? PersistentObjectIdPropertyReader.reader().value(object, name) : property;
        }
        return BeanPropertyReader.reader().value(object, name);
    }
}

