/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.processor;

import com.nhl.link.rest.processor.ProcessingContext;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class ProcessorFactory<E extends Enum<E>, C extends ProcessingContext<?>> {
    private EnumMap<E, Processor<C>> defaultStages;
    private Processor<C> defaultProcessor;

    public ProcessorFactory(EnumMap<E, Processor<C>> defaultStages) {
        this.defaultStages = Objects.requireNonNull(defaultStages);
        this.defaultProcessor = this.composeStages(defaultStages);
    }

    protected Processor<C> composeStages(EnumMap<E, Processor<C>> stages) {
        if (stages.isEmpty()) {
            return c -> ProcessorOutcome.CONTINUE;
        }
        Processor<C> p = null;
        for (Processor<C> s : stages.values()) {
            p = p == null ? s : p.andThen(s);
        }
        return p;
    }

    public Processor<C> createProcessor() {
        return this.defaultProcessor;
    }

    public Processor<C> createProcessor(EnumMap<E, Processor<C>> processors) {
        if (processors.isEmpty()) {
            return this.defaultProcessor;
        }
        Processor<C> p = null;
        for (Map.Entry<E, Processor<C>> e : this.defaultStages.entrySet()) {
            Processor<C> processor = p = p == null ? e.getValue() : p.andThen(e.getValue());
            Processor<C> customProcessor = processors.get(e.getKey());
            if (customProcessor == null) continue;
            p = p.andThen(customProcessor);
        }
        return p;
    }
}

