/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.parser.converter;

import java.util.HashMap;
import java.util.Map;

public class Normalizer {
    private static final Map<Class<?>, TypeNormalizer> NORMALIZERS = new HashMap<Class<?>, TypeNormalizer>(){
        {
            this.put(Long.class, new TypeNormalizer(){

                @Override
                public Object normalize(Object value) {
                    if (!(value instanceof Number)) {
                        return value;
                    }
                    if (value instanceof Long) {
                        return value;
                    }
                    return ((Number)value).longValue();
                }
            });
        }
    };

    public static Object normalize(Object value, Class<?> numericType) {
        TypeNormalizer normalizer = NORMALIZERS.get(numericType);
        return normalizer == null ? value : normalizer.normalize(value);
    }

    static interface TypeNormalizer {
        public Object normalize(Object var1);
    }
}

