/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.parser.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.parser.converter.AbstractConverter;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import javax.ws.rs.core.Response;

public class FloatConverter
extends AbstractConverter {
    private static final JsonValueConverter instance = new FloatConverter();

    public static JsonValueConverter converter() {
        return instance;
    }

    @Override
    protected Object valueNonNull(JsonNode node) {
        if (node.isTextual()) {
            String value = node.asText();
            if ("NaN".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.NaN);
            }
            if ("infinity".equalsIgnoreCase(value) || "+infinity".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if ("-infinity".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        if (!node.isIntegralNumber() && !node.isFloatingPointNumber()) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Expected numeric value, got: " + node.asText());
        }
        Double doubleValue = node.asDouble();
        if (Double.valueOf(0.0).equals(doubleValue)) {
            return Float.valueOf(0.0f);
        }
        Double absDoubleValue = Math.abs(doubleValue);
        if (absDoubleValue < (double)1.4E-45f || absDoubleValue > 3.4028234663852886E38) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Value is either too small or too large for the java.lang.Float datatype: " + node.asText());
        }
        return Float.valueOf(doubleValue.floatValue());
    }
}

