/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.parser.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.parser.converter.AbstractConverter;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;

public class Base64Converter
extends AbstractConverter {
    private static final JsonValueConverter instance = new Base64Converter();

    public static JsonValueConverter converter() {
        return instance;
    }

    @Override
    protected Object valueNonNull(JsonNode node) {
        if (!node.isTextual()) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Expected textual value, got: " + node.asText());
        }
        try {
            return DatatypeConverter.parseBase64Binary((String)node.asText());
        }
        catch (IllegalArgumentException e) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Failed to decode Base64 value: " + node.asText(), e);
        }
    }
}

