/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.multisource;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.SelectBuilder;
import com.nhl.link.rest.multisource.SelectContextSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSelectBuilder<T> {
    private static final Pattern SPLIT_PATH = Pattern.compile("\\.");
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiSelectBuilder.class);
    private SelectBuilder<T> rootChain;
    private ExecutorService executor;
    private Collection<StandaloneChain<?>> standaloneChains;
    private Collection<ParentDependentChain<?>> parentDependentChains;

    MultiSelectBuilder(SelectBuilder<T> rootChain, ExecutorService executor) {
        this.rootChain = Objects.requireNonNull(rootChain);
        this.executor = Objects.requireNonNull(executor);
        this.standaloneChains = new ArrayList();
        this.parentDependentChains = new ArrayList();
    }

    public <U> MultiSelectBuilder<T> parallel(Supplier<U> fetcher, BiConsumer<List<T>, U> merger) {
        return this.parallel("", fetcher, merger);
    }

    public <U, P> MultiSelectBuilder<T> parallel(String pathToParents, Supplier<U> fetcher, BiConsumer<List<P>, U> merger) {
        BiConsumer<DataResponse, Object> lazyMerger = (r, u) -> {
            List parents = (List)r.getIncludedObjects(Object.class, pathToParents);
            if (!parents.isEmpty()) {
                merger.accept(parents, u);
            }
        };
        this.standaloneChains.add(new StandaloneChain<Object>(fetcher, lazyMerger));
        return this;
    }

    public <U, P> MultiSelectBuilder<T> afterParent(String pathToParents, BiFunction<List<P>, ResourceEntity<P>, U> fetcher, BiConsumer<List<P>, U> merger) {
        return this.afterParent(pathToParents, fetcher, merger, Integer.MAX_VALUE);
    }

    public <U> MultiSelectBuilder<T> afterParent(BiFunction<List<T>, ResourceEntity<T>, U> fetcher, BiConsumer<List<T>, U> merger) {
        return this.afterParent(fetcher, merger, Integer.MAX_VALUE);
    }

    public <U> MultiSelectBuilder<T> afterParent(BiFunction<List<T>, ResourceEntity<T>, U> fetcher, BiConsumer<List<T>, U> merger, int parentBatchSize) {
        return this.afterParent("", fetcher, merger, parentBatchSize);
    }

    public <U, P> MultiSelectBuilder<T> afterParent(String pathToParents, BiFunction<List<P>, ResourceEntity<P>, U> fetcher, BiConsumer<List<P>, U> merger, int parentBatchSize) {
        SelectContextSource contextSource = new SelectContextSource();
        this.rootChain.listener(contextSource);
        Function<List, Object> curriedFetcher = parents -> {
            String[] paths;
            ResourceEntity rootEntity;
            ResourceEntity<Object> subEntity = rootEntity = contextSource.getContext().getEntity();
            for (String path : paths = pathToParents == null || pathToParents.length() == 0 ? new String[]{} : SPLIT_PATH.split(pathToParents)) {
                subEntity = Objects.requireNonNull(subEntity.getChild(path), "Invalid entity for path component: " + path);
            }
            return fetcher.apply((List)parents, (ResourceEntity)subEntity);
        };
        return this.afterParent(pathToParents, curriedFetcher, merger, parentBatchSize);
    }

    public <U, P> MultiSelectBuilder<T> afterParent(String pathToParents, Function<List<P>, U> fetcher, BiConsumer<List<P>, U> merger) {
        return this.afterParent(pathToParents, fetcher, merger, Integer.MAX_VALUE);
    }

    public <U> MultiSelectBuilder<T> afterParent(Function<List<T>, U> fetcher, BiConsumer<List<T>, U> merger) {
        return this.afterParent(fetcher, merger, Integer.MAX_VALUE);
    }

    public <U> MultiSelectBuilder<T> afterParent(Function<List<T>, U> fetcher, BiConsumer<List<T>, U> merger, int parentBatchSize) {
        return this.afterParent("", fetcher, merger, parentBatchSize);
    }

    public <U, P> MultiSelectBuilder<T> afterParent(String pathToParents, Function<List<P>, U> fetcher, BiConsumer<List<P>, U> merger, int parentBatchSize) {
        double batchSizeDouble = parentBatchSize <= 0 ? 2.147483647E9 : (double)parentBatchSize;
        BiConsumer<DataResponse, ResultWithParentsTuple> lazyMerger = (r, u) -> {
            if (u.result != null && !u.parents.isEmpty()) {
                merger.accept(u.parents, u.result);
            }
        };
        Function<DataResponse, ResultWithParentsTuple> lazyFetcher = r -> {
            List parents = (List)r.getIncludedObjects(Object.class, pathToParents);
            int batches = (int)Math.ceil((double)parents.size() / batchSizeDouble);
            if (batches <= 1) {
                return ResultWithParentsTuple.fetch(parents, fetcher);
            }
            CompletionStage combinedFuture = CompletableFuture.completedFuture(r);
            for (int i = 0; i < batches; ++i) {
                int start = i * parentBatchSize;
                int end = i + 1 == batches ? parents.size() : start + parentBatchSize;
                List subParents = parents.subList(start, end);
                CompletableFuture future = new StandaloneChain<ResultWithParentsTuple>(() -> ResultWithParentsTuple.fetch(subParents, fetcher), lazyMerger).buildChain(combinedFuture);
                combinedFuture = combinedFuture.thenCombine((CompletionStage)future, (r1, r2) -> r1);
            }
            combinedFuture.join();
            return new ResultWithParentsTuple();
        };
        this.parentDependentChains.add(new ParentDependentChain<ResultWithParentsTuple>(lazyFetcher, lazyMerger));
        return this;
    }

    public DataResponse<T> select(long timeout, TimeUnit timeoutUnit) {
        try {
            return this.selectAsync().get(timeout, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.info("Async fetcher error", (Throwable)e);
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Error fetching games", e);
        }
    }

    public CompletableFuture<DataResponse<T>> selectAsync() {
        CompletableFuture rootFuture = CompletableFuture.supplyAsync(() -> this.rootChain.get(), this.executor);
        ArrayList futures = new ArrayList();
        for (StandaloneChain<?> standaloneChain : this.standaloneChains) {
            futures.add(standaloneChain.buildChain(rootFuture));
        }
        for (ParentDependentChain parentDependentChain : this.parentDependentChains) {
            futures.add(parentDependentChain.buildChain(rootFuture));
        }
        if (futures.isEmpty()) {
            return rootFuture;
        }
        CompletableFuture combinedFuture = null;
        for (CompletableFuture completableFuture : futures) {
            combinedFuture = combinedFuture == null ? completableFuture : combinedFuture.thenCombine((CompletionStage)completableFuture, (r1, r2) -> r1);
        }
        return combinedFuture;
    }

    class ParentDependentChain<U> {
        private Function<DataResponse<T>, U> fetcher;
        private BiConsumer<DataResponse<T>, U> merger;

        public ParentDependentChain(Function<DataResponse<T>, U> fetcher, BiConsumer<DataResponse<T>, U> merger) {
            this.fetcher = Objects.requireNonNull(fetcher);
            this.merger = Objects.requireNonNull(merger);
        }

        CompletableFuture<DataResponse<T>> buildChain(CompletableFuture<DataResponse<T>> rootResult) {
            Function<DataResponse, CompletableFuture> fetcherAsAsyncFunction = r -> CompletableFuture.supplyAsync(() -> this.fetcher.apply((DataResponse<DataResponse>)r), MultiSelectBuilder.this.executor);
            CompletionStage chainFuture = rootResult.thenCompose(fetcherAsAsyncFunction);
            BiFunction<DataResponse, Object, DataResponse> mergerAsFunction = (r, u) -> {
                this.merger.accept((DataResponse<DataResponse>)r, u);
                return r;
            };
            return rootResult.thenCombine(chainFuture, mergerAsFunction);
        }
    }

    class StandaloneChain<U> {
        private Supplier<U> fetcher;
        private BiConsumer<DataResponse<T>, U> merger;

        public StandaloneChain(Supplier<U> fetcher, BiConsumer<DataResponse<T>, U> merger) {
            this.fetcher = Objects.requireNonNull(fetcher);
            this.merger = Objects.requireNonNull(merger);
        }

        CompletableFuture<DataResponse<T>> buildChain(CompletableFuture<DataResponse<T>> rootResult) {
            CompletableFuture<U> chainFuture = CompletableFuture.supplyAsync(this.fetcher, MultiSelectBuilder.this.executor);
            BiFunction<DataResponse, Object, DataResponse> mergerAsFunction = (r, u) -> {
                this.merger.accept((DataResponse<DataResponse>)r, u);
                return r;
            };
            return rootResult.thenCombine(chainFuture, mergerAsFunction);
        }
    }

    static class ResultWithParentsTuple<P, U> {
        List<P> parents;
        U result;

        ResultWithParentsTuple() {
        }

        static <P, U> ResultWithParentsTuple<P, U> fetch(List<P> parents, Function<List<P>, U> fetcher) {
            ResultWithParentsTuple<P, U> tuple = new ResultWithParentsTuple<P, U>();
            tuple.parents = parents;
            if (!tuple.parents.isEmpty()) {
                tuple.result = fetcher.apply(tuple.parents);
            }
            return tuple;
        }
    }
}

