/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta.parser;

import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.meta.DefaultLrOperation;
import com.nhl.link.rest.meta.DefaultLrResource;
import com.nhl.link.rest.meta.LinkMethodType;
import com.nhl.link.rest.meta.LinkType;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrResource;
import com.nhl.link.rest.meta.annotation.Resource;
import com.nhl.link.rest.meta.parser.IResourceParser;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.cayenne.di.Inject;

public class ResourceParser
implements IResourceParser {
    private IMetadataService metadataService;

    public ResourceParser(@Inject IMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public <T> Collection<LrResource<?>> parse(Class<T> resourceClass) {
        Path root = resourceClass.getAnnotation(Path.class);
        if (root == null) {
            return Collections.emptySet();
        }
        Method[] methods = resourceClass.getDeclaredMethods();
        TreeMap<String, HashSet<Method>> methodsMap = new TreeMap<String, HashSet<Method>>();
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers()) || ResourceParser.getMethodType(method) == null) continue;
            String path = ResourceParser.buildPath(ResourceParser.getPath(resourceClass), ResourceParser.getPath(method));
            HashSet<Method> methodsByPath = (HashSet<Method>)methodsMap.get(path);
            if (methodsByPath == null) {
                methodsByPath = new HashSet<Method>();
            }
            methodsByPath.add(method);
            methodsMap.put(path, methodsByPath);
        }
        ArrayList resources = new ArrayList();
        for (Map.Entry methodsByPath : methodsMap.entrySet()) {
            resources.add(this.createResource((String)methodsByPath.getKey(), (Set)methodsByPath.getValue()));
        }
        return resources;
    }

    private LrResource<?> createResource(String path, Set<Method> methods) {
        DefaultLrResource resource = new DefaultLrResource();
        LinkType resourceType = LinkType.UNDEFINED;
        for (Method method : methods) {
            LinkMethodType methodType;
            Type returnType;
            Resource annotation = method.getAnnotation(Resource.class);
            LrEntity<Object> entity = null;
            if (annotation != null) {
                LinkType annotatedType = annotation.type();
                if (resourceType == LinkType.UNDEFINED) {
                    resourceType = annotatedType;
                } else if (annotatedType != LinkType.UNDEFINED && annotatedType != resourceType) {
                    throw new IllegalStateException("Conflicting resource type annotations detected for resource: " + path);
                }
            }
            if (annotation != null && !annotation.entityClass().equals(Object.class)) {
                Class<?> entityClass = annotation.entityClass();
                entity = this.metadataService.getLrEntity(entityClass);
                if (entity == null) {
                    throw new IllegalStateException("Unknown entity class: " + entityClass.getName());
                }
            } else if (DataResponse.class.isAssignableFrom(method.getReturnType()) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType) {
                entity = this.metadataService.getLrEntity((Class)((ParameterizedType)returnType).getActualTypeArguments()[0]);
            }
            if (entity != null) {
                if (resource.getEntity() != null && !resource.getEntity().getName().equals(entity.getName())) {
                    throw new IllegalStateException("Conflicting entity class annotations detected for resource: " + path);
                }
                resource.setEntity(entity);
            }
            if ((methodType = ResourceParser.getMethodType(method)) == null) continue;
            resource.addOperation(new DefaultLrOperation(methodType));
        }
        resource.setPath(path);
        resource.setType(resourceType);
        return resource;
    }

    private static LinkMethodType getMethodType(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return LinkMethodType.GET;
        }
        if (method.getAnnotation(POST.class) != null) {
            return LinkMethodType.POST;
        }
        if (method.getAnnotation(PUT.class) != null) {
            return LinkMethodType.PUT;
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return LinkMethodType.DELETE;
        }
        return null;
    }

    private static String getPath(AnnotatedElement element) {
        Path path = element.getAnnotation(Path.class);
        return path == null ? "" : path.value();
    }

    private static String buildPath(String root, String suffix) {
        if (ResourceParser.isEmpty(root)) {
            if (ResourceParser.isEmpty(suffix)) {
                throw new IllegalStateException("Root and suffix cannot both be empty");
            }
            return suffix;
        }
        return ResourceParser.isEmpty(suffix) ? root : root + "/" + suffix;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

