/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta.compiler;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrDataMap;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrEntityBuilder;
import com.nhl.link.rest.meta.compiler.LazyLrEntity;
import com.nhl.link.rest.meta.compiler.LrEntityCompiler;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import javax.ws.rs.core.Response;
import org.apache.cayenne.di.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoEntityCompiler
implements LrEntityCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoEntityCompiler.class);
    private IJsonValueConverterFactory converterFactory;

    public PojoEntityCompiler(@Inject IJsonValueConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    @Override
    public <T> LrEntity<T> compile(Class<T> type, LrDataMap dataMap) {
        return new LazyLrEntity<T>(type, () -> this.doCompile(type, dataMap));
    }

    private <T> LrEntity<T> doCompile(Class<T> type, LrDataMap dataMap) {
        LOGGER.debug("compiling entity for type: " + type);
        LrEntity<T> entity = new LrEntityBuilder<T>(type, dataMap, this.converterFactory).build();
        if (entity.getIds().isEmpty() && entity.getAttributes().isEmpty() && entity.getRelationships().isEmpty()) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Not an entity: " + type.getName());
        }
        return entity;
    }
}

