/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta.cayenne;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentRelationship;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;

public class CayenneLrRelationship
implements LrPersistentRelationship {
    private ObjRelationship objRelationship;
    private LrEntity<?> targetEntity;
    private JsonValueConverter converter;

    public CayenneLrRelationship(ObjRelationship objRelationship, LrEntity<?> targetEntity, JsonValueConverter converter) {
        this.objRelationship = objRelationship;
        this.targetEntity = Objects.requireNonNull(targetEntity);
        this.converter = converter;
    }

    @Override
    public String getName() {
        return this.objRelationship.getName();
    }

    @Override
    public LrEntity<?> getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public boolean isToMany() {
        return this.objRelationship.isToMany();
    }

    @Override
    public boolean isToDependentEntity() {
        return this.getDbRelationship().isToDependentPK();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.getDbRelationship().getReverseRelationship().isToDependentPK();
    }

    private DbRelationship getDbRelationship() {
        return (DbRelationship)this.objRelationship.getDbRelationships().get(0);
    }

    @Override
    public Map<String, Object> extractId(LrObjectId id) {
        return this.extractId(id::get);
    }

    @Override
    public Map<String, Object> extractId(JsonNode id) {
        if (this.isMultiJoin()) {
            if (!id.isObject()) {
                throw new IllegalArgumentException("Relationship has multiple joins, but only a scalar value was provided");
            }
            return this.extractId(arg_0 -> ((JsonNode)id).get(arg_0));
        }
        if (id.isObject()) {
            return this.extractId(arg_0 -> ((JsonNode)id).get(arg_0));
        }
        return Collections.singletonMap(((DbJoin)this.getDbRelationship().getReverseRelationship().getJoins().iterator().next()).getTargetName(), this.converter.value(id));
    }

    private Map<String, Object> extractId(Function<String, Object> idPartSupplier) {
        HashMap<String, Object> parentIdMap = new HashMap<String, Object>();
        for (DbRelationship dbRelationship : this.objRelationship.getDbRelationships()) {
            DbRelationship reverseRelationship = dbRelationship.getReverseRelationship();
            for (DbJoin join : reverseRelationship.getJoins()) {
                parentIdMap.put(join.getSourceName(), idPartSupplier.apply(join.getTargetName()));
            }
        }
        return parentIdMap;
    }

    private boolean isMultiJoin() {
        return this.getDbRelationship().getReverseRelationship().getJoins().size() > 1;
    }
}

