/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta.cayenne;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.DefaultLrAttribute;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrDataMap;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrEntityBuilder;
import com.nhl.link.rest.meta.LrEntityOverlay;
import com.nhl.link.rest.meta.LrPersistentEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.meta.cayenne.CayenneLrAttribute;
import com.nhl.link.rest.meta.cayenne.CayenneLrDbAttribute;
import com.nhl.link.rest.meta.cayenne.CayenneLrEntity;
import com.nhl.link.rest.meta.cayenne.CayenneLrRelationship;
import com.nhl.link.rest.meta.compiler.LazyLrPersistentEntity;
import com.nhl.link.rest.meta.compiler.LrEntityCompiler;
import com.nhl.link.rest.runtime.cayenne.ICayennePersister;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CayenneEntityCompiler
implements LrEntityCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CayenneEntityCompiler.class);
    private EntityResolver resolver;
    private Map<String, LrEntityOverlay> entityOverlays;
    private IJsonValueConverterFactory converterFactory;

    static Class<?> getJavaTypeForTypeName(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("Attribute type cannot be null");
        }
        switch (typeName) {
            case "byte[]": {
                return byte[].class;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown class: " + typeName, e);
        }
    }

    public CayenneEntityCompiler(@Inject ICayennePersister cayennePersister, @Inject Map<String, LrEntityOverlay> entityOverlays, @Inject IJsonValueConverterFactory converterFactory) {
        this.resolver = cayennePersister.entityResolver();
        this.entityOverlays = entityOverlays;
        this.converterFactory = converterFactory;
    }

    @Override
    public <T> LrEntity<T> compile(Class<T> type, LrDataMap dataMap) {
        ObjEntity objEntity = this.resolver.getObjEntity(type);
        if (objEntity == null) {
            return null;
        }
        return new LazyLrPersistentEntity<T>(type, () -> this.doCompile(type, dataMap));
    }

    private <T> LrPersistentEntity<T> doCompile(Class<T> type, LrDataMap dataMap) {
        LOGGER.debug("compiling Cayenne entity for type: " + type);
        ObjEntity objEntity = this.resolver.getObjEntity(type);
        CayenneLrEntity<T> lrEntity = new CayenneLrEntity<T>(type, objEntity);
        this.loadCayenneEntity(lrEntity, dataMap);
        this.loadAnnotatedProperties(lrEntity, dataMap);
        this.loadOverlays(lrEntity);
        return lrEntity;
    }

    protected <T> void loadCayenneEntity(CayenneLrEntity<T> lrEntity, LrDataMap dataMap) {
        ObjEntity objEntity = lrEntity.getObjEntity();
        for (ObjAttribute a : objEntity.getAttributes()) {
            Class<?> type = CayenneEntityCompiler.getJavaTypeForTypeName(a.getType());
            CayenneLrAttribute lrAttribute = new CayenneLrAttribute(a, type);
            lrEntity.addPersistentAttribute(lrAttribute);
        }
        for (ObjRelationship r : objEntity.getRelationships()) {
            List dbRelationshipsList = r.getDbRelationships();
            Class targetEntityType = this.resolver.getClassDescriptor(r.getTargetEntityName()).getObjectClass();
            LrEntity targetEntity = dataMap.getEntity(targetEntityType);
            DbRelationship targetRelationship = (DbRelationship)dbRelationshipsList.get(dbRelationshipsList.size() - 1);
            int targetJdbcType = ((DbJoin)targetRelationship.getJoins().get(0)).getTarget().getType();
            Class<?> type = CayenneEntityCompiler.getJavaTypeForTypeName(TypesMapping.getJavaBySqlType((int)targetJdbcType));
            CayenneLrRelationship lrRelationship = new CayenneLrRelationship(r, targetEntity, this.converterFactory.converter(type));
            lrEntity.addRelationship(lrRelationship);
        }
        for (DbAttribute pk : objEntity.getDbEntity().getPrimaryKeys()) {
            CayenneLrAttribute id;
            Class<?> type;
            ObjAttribute attribute = objEntity.getAttributeForDbAttribute(pk);
            if (attribute == null) {
                type = CayenneEntityCompiler.getJavaTypeForTypeName(TypesMapping.getJavaBySqlType((int)pk.getType()));
                id = new CayenneLrDbAttribute(pk.getName(), pk, type);
            } else {
                type = CayenneEntityCompiler.getJavaTypeForTypeName(attribute.getType());
                id = new CayenneLrAttribute(attribute, type);
            }
            lrEntity.addId(id);
        }
    }

    protected <T> void loadAnnotatedProperties(CayenneLrEntity<T> entity, LrDataMap dataMap) {
        Object existing;
        LrEntity annotatedEntity = new LrEntityBuilder(entity.getType(), dataMap, this.converterFactory).build();
        if (annotatedEntity.getIds().size() > 0) {
            for (LrAttribute id : annotatedEntity.getIds()) {
                existing = entity.addId(id);
                if (existing == null || !LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("ID attribute '" + existing.getName() + "' is overridden from annotations.");
            }
            Iterator<LrAttribute> iter = entity.getIds().iterator();
            while (iter.hasNext()) {
                LrAttribute id;
                id = iter.next();
                if (annotatedEntity.getIds().contains(id)) continue;
                iter.remove();
            }
        }
        for (LrAttribute attribute : annotatedEntity.getAttributes()) {
            existing = entity.addAttribute(attribute);
            if (existing == null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Attribute '" + existing.getName() + "' is overridden from annotations.");
        }
        for (LrRelationship relationship : annotatedEntity.getRelationships()) {
            existing = entity.addRelationship(relationship);
            if (existing == null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Relationship '" + existing.getName() + "' is overridden from annotations.");
        }
    }

    protected <T> void loadOverlays(CayenneLrEntity<T> entity) {
        LrEntityOverlay overlay = this.entityOverlays.get(entity.getType().getName());
        if (overlay != null) {
            for (String a : overlay.getTransientAttributes()) {
                DefaultLrAttribute lrAttribute = new DefaultLrAttribute(a, Object.class);
                entity.addAttribute(lrAttribute);
            }
        }
    }
}

