/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta;

import com.nhl.link.rest.annotation.LrAttribute;
import com.nhl.link.rest.annotation.LrId;
import com.nhl.link.rest.annotation.LrRelationship;
import com.nhl.link.rest.meta.DefaultLrAttribute;
import com.nhl.link.rest.meta.DefaultLrEntity;
import com.nhl.link.rest.meta.DefaultLrRelationship;
import com.nhl.link.rest.meta.LrDataMap;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrEntityBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LrEntityBuilder.class);
    private static final Pattern GETTER = Pattern.compile("^(get|is)([A-Z].*)$");
    private Class<T> type;
    private LrDataMap dataMap;
    private IJsonValueConverterFactory converterFactory;

    public LrEntityBuilder(Class<T> type, LrDataMap dataMap, IJsonValueConverterFactory converterFactory) {
        this.type = type;
        this.dataMap = dataMap;
        this.converterFactory = converterFactory;
    }

    public LrEntity<T> build() {
        DefaultLrEntity<T> e = new DefaultLrEntity<T>(this.type);
        this.appendProperties(e);
        return e;
    }

    private void appendProperties(DefaultLrEntity<T> entity) {
        for (Method method : this.type.getMethods()) {
            this.appendProperty(entity, method);
        }
    }

    private void appendProperty(DefaultLrEntity<T> entity, Method m) {
        Class<?> type = m.getReturnType();
        if (type.equals(Void.class) || m.getParameterTypes().length > 0) {
            return;
        }
        String name = this.toPropertyName(m.getName());
        if (name == null) {
            return;
        }
        if (name.equals("class")) {
            return;
        }
        if (!this.addAsAttribute(entity, name, m)) {
            this.addAsRelationship(entity, name, m);
        }
    }

    String toPropertyName(String methodName) {
        Matcher matcher = GETTER.matcher(methodName);
        if (!matcher.find()) {
            return null;
        }
        String raw = matcher.group(2);
        return Character.toLowerCase(raw.charAt(0)) + raw.substring(1);
    }

    private boolean addAsAttribute(DefaultLrEntity<T> entity, String name, Method m) {
        Class<?> type = m.getReturnType();
        if (m.getAnnotation(LrAttribute.class) != null) {
            if (this.checkValidAttributeType(type, m.getGenericReturnType())) {
                DefaultLrAttribute a = new DefaultLrAttribute(name, type);
                entity.addAttribute(a);
            } else {
                LOGGER.warn("Invalid attribute type for " + entity.getName() + "." + name + ". Skipping.");
            }
            return true;
        }
        if (m.getAnnotation(LrId.class) != null) {
            if (this.checkValidIdType(type)) {
                DefaultLrAttribute a = new DefaultLrAttribute(name, type);
                entity.addId(a);
            } else {
                LOGGER.warn("Invalid ID attribute type for " + entity.getName() + "." + name + ". Skipping.");
            }
            return true;
        }
        return false;
    }

    private boolean checkValidAttributeType(Class<?> type, Type genericType) {
        if (Void.class.equals(type) || Void.TYPE.equals(type) || Map.class.isAssignableFrom(type)) {
            return false;
        }
        return !Collection.class.isAssignableFrom(type) || this.isCollectionOfSimpleType(type, genericType);
    }

    private boolean isCollectionOfSimpleType(Class<?> type, Type genericType) {
        ParameterizedType pt;
        Type[] typeArgs;
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (typeArgs = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            return this.isSimpleType(typeArgs[0]);
        }
        return false;
    }

    private boolean isSimpleType(Type rawType) {
        Type[] bounds;
        Class cls = null;
        if (rawType instanceof Class) {
            cls = (Class)rawType;
        } else if (rawType instanceof WildcardType) {
            Type[] bounds2 = ((WildcardType)rawType).getUpperBounds();
            if (bounds2.length == 1 && bounds2[0] instanceof Class) {
                cls = (Class)bounds2[0];
            }
        } else if (rawType instanceof TypeVariable && (bounds = ((TypeVariable)rawType).getBounds()).length == 1 && bounds[0] instanceof Class) {
            cls = (Class)bounds[0];
        }
        if (cls != null) {
            return String.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls) || Character.class.isAssignableFrom(cls);
        }
        return false;
    }

    private boolean checkValidIdType(Class<?> type) {
        return !Void.class.equals(type) && !Void.TYPE.equals(type) && !Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type);
    }

    private boolean addAsRelationship(DefaultLrEntity<T> entity, String name, Method m) {
        if (m.getAnnotation(LrRelationship.class) != null) {
            Class targetType = m.getReturnType();
            boolean toMany = false;
            if (Collection.class.isAssignableFrom(targetType)) {
                targetType = (Class)((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0];
                toMany = true;
            }
            LrEntity<?> targetEntity = this.dataMap.getEntity(targetType);
            entity.addRelationship(new DefaultLrRelationship(name, targetEntity, toMany));
        }
        return false;
    }
}

