/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta;

import com.nhl.link.rest.meta.LrDataMap;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.compiler.LrEntityCompiler;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LazyLrDataMap
implements LrDataMap {
    private Collection<LrEntityCompiler> compilers;
    private ConcurrentMap<Class<?>, LrEntity<?>> entities;

    public LazyLrDataMap(Collection<LrEntityCompiler> compilers) {
        this.compilers = compilers;
        this.entities = new ConcurrentHashMap();
    }

    @Override
    public <T> LrEntity<T> getEntity(Class<T> type) {
        LrEntity<T> e = (LrEntity<T>)this.entities.get(type);
        if (e == null) {
            LrEntity<T> newEntity = this.compile(type);
            LrEntity<T> existingEntity = this.entities.putIfAbsent(type, newEntity);
            e = existingEntity != null ? existingEntity : newEntity;
        }
        return e;
    }

    protected <T> LrEntity<T> compile(Class<T> type) {
        for (LrEntityCompiler compiler : this.compilers) {
            LrEntity<T> e = compiler.compile(type, this);
            if (e == null) continue;
            return e;
        }
        throw new IllegalArgumentException("Unable to compile LrEntity: " + type);
    }
}

