/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.meta;

import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultLrEntity<T>
implements LrEntity<T> {
    private String name;
    private Class<T> type;
    private Map<String, LrAttribute> ids;
    private Map<String, LrAttribute> attributes;
    private Map<String, LrRelationship> relationships;

    public DefaultLrEntity(Class<T> type) {
        this.type = type;
        this.relationships = new HashMap<String, LrRelationship>();
        this.attributes = new HashMap<String, LrAttribute>();
        this.ids = new HashMap<String, LrAttribute>();
        this.name = type.getSimpleName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Collection<LrAttribute> getIds() {
        return this.ids.values();
    }

    @Override
    public LrRelationship getRelationship(String name) {
        return this.relationships.get(name);
    }

    @Override
    public LrAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Collection<LrRelationship> getRelationships() {
        return this.relationships.values();
    }

    @Override
    public Collection<LrAttribute> getAttributes() {
        return this.attributes.values();
    }

    public LrRelationship addRelationship(LrRelationship relationship) {
        return this.relationships.put(relationship.getName(), relationship);
    }

    public LrAttribute addAttribute(LrAttribute attribute) {
        return this.attributes.put(attribute.getName(), attribute);
    }

    public LrAttribute addId(LrAttribute id) {
        return this.ids.put(id.getName(), id);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.getName() + "]";
    }
}

