/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.AbstractEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.meta.LrRelationship;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;

public abstract class PropertyMetadataEncoder
extends AbstractEncoder {
    private static final Encoder instance = new PropertyMetadataEncoder(){

        @Override
        protected String getPropertyName(Object property) {
            if (property instanceof LrAttribute) {
                return ((LrAttribute)property).getName();
            }
            if (property instanceof LrRelationship) {
                return ((LrRelationship)property).getName();
            }
            return null;
        }

        @Override
        protected TypeDescription getPropertyType(Object property) {
            if (property instanceof LrAttribute) {
                Class<?> type = ((LrAttribute)property).getType();
                switch (type.getName()) {
                    case "byte": 
                    case "short": 
                    case "int": {
                        return TypeDescription.int32();
                    }
                    case "long": {
                        return TypeDescription.int64();
                    }
                    case "float": {
                        return TypeDescription.float32();
                    }
                    case "double": {
                        return TypeDescription.float64();
                    }
                    case "[B": {
                        return TypeDescription.base64();
                    }
                    case "char": 
                    case "java.lang.Character": 
                    case "java.lang.String": {
                        return TypeDescription.string();
                    }
                    case "boolean": 
                    case "java.lang.Boolean": {
                        return new TypeDescription("boolean");
                    }
                }
                if (Number.class.isAssignableFrom(type)) {
                    if (Byte.class.equals(type) || Short.class.equals(type) || Integer.class.equals(type)) {
                        return TypeDescription.int32();
                    }
                    if (Long.class.equals(type)) {
                        return TypeDescription.int64();
                    }
                    if (Float.class.equals(type)) {
                        return TypeDescription.float32();
                    }
                    if (Double.class.equals(type)) {
                        return TypeDescription.float64();
                    }
                    return TypeDescription.number();
                }
                if (java.util.Date.class.isAssignableFrom(type)) {
                    if (Date.class.equals(type) || Timestamp.class.equals(type)) {
                        return TypeDescription.datetime();
                    }
                    if (Time.class.equals(type)) {
                        return TypeDescription.time();
                    }
                    return TypeDescription.datetime();
                }
                if (LocalDate.class.equals(type)) {
                    return TypeDescription.date();
                }
                if (LocalDateTime.class.equals(type)) {
                    return TypeDescription.datetime();
                }
                if (LocalTime.class.equals(type)) {
                    return TypeDescription.time();
                }
            } else if (property instanceof LrRelationship) {
                String entityName = ((LrRelationship)property).getTargetEntity().getName();
                return new TypeDescription(entityName);
            }
            return null;
        }

        @Override
        protected void doEncode(Object property, JsonGenerator out) throws IOException {
            if (property instanceof LrPersistentAttribute) {
                if (((LrPersistentAttribute)property).isMandatory()) {
                    out.writeBooleanField("mandatory", true);
                }
            } else if (property instanceof LrRelationship) {
                out.writeBooleanField("relationship", true);
                if (((LrRelationship)property).isToMany()) {
                    out.writeBooleanField("collection", true);
                }
            }
        }
    };

    public static Encoder encoder() {
        return instance;
    }

    @Override
    protected boolean encodeNonNullObject(Object property, JsonGenerator out) throws IOException {
        if (property == null) {
            return false;
        }
        out.writeStartObject();
        out.writeStringField("name", this.getPropertyName(property));
        TypeDescription type = this.getPropertyType(property);
        out.writeStringField("type", type.getTypeName());
        Optional<String> format = type.getFormat();
        if (format.isPresent()) {
            out.writeStringField("format", format.get());
        }
        this.doEncode(property, out);
        out.writeEndObject();
        return true;
    }

    protected abstract String getPropertyName(Object var1);

    protected abstract TypeDescription getPropertyType(Object var1);

    protected abstract void doEncode(Object var1, JsonGenerator var2) throws IOException;

    private static class TypeDescription {
        static final String NUMBER_TYPE = "number";
        static final String STRING_TYPE = "string";
        static final String DATE_TYPE = "date";
        private String typeName;
        private Optional<String> format;

        static TypeDescription int32() {
            return new TypeDescription(NUMBER_TYPE, "int32");
        }

        static TypeDescription int64() {
            return new TypeDescription(NUMBER_TYPE, "int64");
        }

        static TypeDescription float32() {
            return new TypeDescription(NUMBER_TYPE, "float");
        }

        static TypeDescription float64() {
            return new TypeDescription(NUMBER_TYPE, "double");
        }

        static TypeDescription number() {
            return new TypeDescription(NUMBER_TYPE);
        }

        static TypeDescription base64() {
            return new TypeDescription(STRING_TYPE, "byte");
        }

        static TypeDescription string() {
            return new TypeDescription(STRING_TYPE);
        }

        static TypeDescription date() {
            return new TypeDescription(DATE_TYPE, "full-date");
        }

        static TypeDescription datetime() {
            return new TypeDescription(DATE_TYPE, "date-time");
        }

        static TypeDescription time() {
            return new TypeDescription(DATE_TYPE, "full-time");
        }

        TypeDescription(String typeName, String format) {
            this.typeName = typeName;
            this.format = Optional.of(format);
        }

        TypeDescription(String typeName) {
            this.typeName = typeName;
            this.format = Optional.empty();
        }

        String getTypeName() {
            return this.typeName;
        }

        Optional<String> getFormat() {
            return this.format;
        }
    }
}

