/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.CollectionEncoder;
import com.nhl.link.rest.encoder.EncoderVisitor;
import com.nhl.link.rest.encoder.converter.StringConverter;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.encoder.IAttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.IStringConverterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;

public class MapByEncoder
implements CollectionEncoder {
    private String mapByPath;
    private List<Function<Object, ?>> mapByReaders;
    private CollectionEncoder collectionEncoder;
    private boolean byId;
    private StringConverter fieldNameConverter;
    private Expression filter;

    public MapByEncoder(String mapByPath, Expression filter, ResourceEntity<?> mapBy, CollectionEncoder collectionEncoder, IStringConverterFactory converterFactory, IAttributeEncoderFactory encoderFactory) {
        if (mapBy == null) {
            throw new NullPointerException("Null mapBy");
        }
        this.mapByPath = mapByPath;
        this.mapByReaders = new ArrayList();
        this.collectionEncoder = collectionEncoder;
        this.filter = filter;
        this.config(converterFactory, encoderFactory, mapBy);
    }

    private static Function<Object, ?> getPropertyReader(String propertyName, EntityProperty property) {
        return it -> property.read(it, propertyName);
    }

    @Override
    public boolean willEncode(String propertyName, Object object) {
        return true;
    }

    @Override
    public int visitEntities(Object object, EncoderVisitor visitor) {
        return this.collectionEncoder.visitEntities(object, visitor);
    }

    private void config(IStringConverterFactory converterFactory, IAttributeEncoderFactory encoderFactory, ResourceEntity<?> mapBy) {
        if (mapBy.isIdIncluded()) {
            this.validateLeafMapBy(mapBy);
            this.byId = true;
            this.mapByReaders.add(MapByEncoder.getPropertyReader(null, encoderFactory.getIdProperty(mapBy)));
            this.fieldNameConverter = converterFactory.getConverter(mapBy.getLrEntity());
            return;
        }
        if (!mapBy.getAttributes().isEmpty()) {
            this.validateLeafMapBy(mapBy);
            this.byId = false;
            Map.Entry<String, LrAttribute> attribute = mapBy.getAttributes().entrySet().iterator().next();
            this.mapByReaders.add(MapByEncoder.getPropertyReader(attribute.getKey(), encoderFactory.getAttributeProperty(mapBy.getLrEntity(), attribute.getValue())));
            this.fieldNameConverter = converterFactory.getConverter(mapBy.getLrEntity(), attribute.getKey());
            return;
        }
        if (!mapBy.getChildren().isEmpty()) {
            this.byId = false;
            Map.Entry<String, ResourceEntity<?>> child = mapBy.getChildren().entrySet().iterator().next();
            LrRelationship relationship = mapBy.getLrEntity().getRelationship(child.getKey());
            this.mapByReaders.add(MapByEncoder.getPropertyReader(child.getKey(), encoderFactory.getRelationshipProperty(mapBy.getLrEntity(), relationship, null)));
            ResourceEntity<?> childMapBy = mapBy.getChildren().get(child.getKey());
            this.config(converterFactory, encoderFactory, childMapBy);
            return;
        }
        this.byId = true;
        this.mapByReaders.add(MapByEncoder.getPropertyReader(null, encoderFactory.getIdProperty(mapBy)));
    }

    private void validateLeafMapBy(ResourceEntity<?> mapBy) {
        if (!mapBy.getChildren().isEmpty()) {
            StringBuilder message = new StringBuilder("'mapBy' path segment '");
            message.append(mapBy.getIncoming().getName()).append("should not have children. Full 'mapBy' path: " + this.mapByPath);
            throw new LinkRestException(Response.Status.BAD_REQUEST, message.toString());
        }
    }

    @Override
    public int encodeAndGetTotal(String propertyName, Object object, JsonGenerator out) throws IOException {
        if (propertyName != null) {
            out.writeFieldName(propertyName);
        }
        if (object == null) {
            out.writeNull();
            return 0;
        }
        List objects = (List)object;
        Map<String, List<Object>> map = this.mapBy(objects);
        out.writeStartObject();
        int total = 0;
        for (Map.Entry<String, List<Object>> e : map.entrySet()) {
            out.writeFieldName(e.getKey());
            total += this.collectionEncoder.encodeAndGetTotal(null, e.getValue(), out);
        }
        out.writeEndObject();
        return total;
    }

    private Object mapByValue(Object object) {
        Object result = object;
        for (Function<Object, ?> reader : this.mapByReaders) {
            if (result == null) break;
            result = reader.apply(result);
        }
        return result;
    }

    private Map<String, List<Object>> mapBy(List<?> objects) {
        if (objects.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        for (Object o : objects) {
            if (this.filter != null && !this.filter.match(o)) continue;
            Object key = this.mapByValue(o);
            if (this.byId) {
                Map id = (Map)key;
                key = id.entrySet().iterator().next().getValue();
            }
            if (key == null) {
                throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Null mapBy value for key '" + this.mapByPath + "'");
            }
            String keyString = this.fieldNameConverter.asString(key);
            ArrayList list = (ArrayList)map.get(keyString);
            if (list == null) {
                list = new ArrayList();
                map.put(keyString, list);
            }
            list.add(o);
        }
        return map;
    }
}

