/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.CollectionEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.Ordering;
import org.apache.commons.collections.ComparatorUtils;

public class ListEncoder
implements CollectionEncoder {
    private Encoder elementEncoder;
    private Collection<Ordering> orderings;
    private Expression filter;
    private int offset;
    private int limit;
    private boolean shouldFilter;

    public ListEncoder(Encoder elementEncoder) {
        this.elementEncoder = elementEncoder;
        this.orderings = Collections.emptyList();
    }

    public ListEncoder(Encoder elementEncoder, Expression filter, Collection<Ordering> orderings) {
        this.elementEncoder = elementEncoder;
        this.orderings = orderings;
        this.filter = filter;
    }

    @Override
    public int visitEntities(Object root, EncoderVisitor visitor) {
        List<?> objects = this.toList(root);
        Counter counter = new Counter();
        this.rewind(counter, objects, this.offset);
        return this.visit(counter, objects, this.limit > 0 ? this.limit : Integer.MAX_VALUE, visitor);
    }

    public ListEncoder withOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public ListEncoder withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public ListEncoder shouldFilter() {
        this.shouldFilter = true;
        return this;
    }

    public ListEncoder shouldFilter(boolean filter) {
        this.shouldFilter = filter;
        return this;
    }

    @Override
    public int encodeAndGetTotal(String propertyName, Object object, JsonGenerator out) throws IOException {
        if (propertyName != null) {
            out.writeFieldName(propertyName);
        }
        List<?> objects = this.toList(object);
        out.writeStartArray();
        Counter counter = new Counter();
        this.rewind(counter, objects, this.offset);
        this.encode(counter, objects, this.limit > 0 ? this.limit : Integer.MAX_VALUE, out);
        this.rewind(counter, objects, objects.size());
        out.writeEndArray();
        return counter.getTotal();
    }

    private List<?> toList(Object object) {
        if (object == null) {
            throw new IllegalStateException("Unexpected null list");
        }
        if (!(object instanceof List)) {
            throw new IllegalStateException("Unexpected object type. Should be a List, got: " + object.getClass().getName());
        }
        ArrayList list = (ArrayList)object;
        if (!this.orderings.isEmpty() && list.size() > 1) {
            list = new ArrayList(list);
            Collections.sort(list, ComparatorUtils.chainedComparator(this.orderings));
        }
        return list;
    }

    private void rewind(Counter c, List<?> objects, int limit) {
        int length = objects.size();
        while (c.position < length && c.rewound < limit) {
            if (this.shouldFilter) {
                Object o = objects.get(c.position);
                if ((this.filter == null || this.filter.match(o)) && this.elementEncoder.willEncode(null, o)) {
                    ++c.rewound;
                }
            } else {
                ++c.rewound;
            }
            ++c.position;
        }
    }

    private void encode(Counter c, List<?> objects, int limit, JsonGenerator out) throws IOException {
        int length = objects.size();
        while (c.position < length && c.encoded < limit) {
            Object o = objects.get(c.position);
            if ((this.filter == null || this.filter.match(o)) && this.elementEncoder.encode(null, objects.get(c.position), out)) {
                ++c.encoded;
            }
            ++c.position;
        }
    }

    private int visit(Counter c, List<?> objects, int limit, EncoderVisitor visitor) {
        int length = objects.size();
        while (c.position < length && c.encoded < limit) {
            Object o = objects.get(c.position);
            if (this.filter == null || this.filter.match(o)) {
                int bitmask = this.elementEncoder.visitEntities(o, visitor);
                ++c.encoded;
                if ((bitmask & 2) != 0) {
                    return 2;
                }
            }
            ++c.position;
        }
        return 0;
    }

    @Override
    public boolean willEncode(String propertyName, Object object) {
        return true;
    }

    final class Counter {
        int position;
        int encoded;
        int rewound;

        Counter() {
        }

        int getTotal() {
            return this.encoded + this.rewound;
        }
    }
}

