/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.encoder.Encoder;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.core.Response;

public class IdEncoder
implements Encoder {
    private Encoder valueEncoder;
    private Map<String, Encoder> valueEncoders;
    private boolean isCompoundId;

    public IdEncoder(Encoder valueEncoder) {
        this.valueEncoder = valueEncoder;
    }

    public IdEncoder(Map<String, Encoder> valueEncoders) {
        this.valueEncoders = valueEncoders;
        this.isCompoundId = true;
    }

    @Override
    public boolean encode(String propertyName, Object object, JsonGenerator out) throws IOException {
        if (object == null) {
            if (propertyName != null) {
                out.writeFieldName(propertyName);
            }
            out.writeNull();
            return true;
        }
        return this.encodeId(propertyName, (Map)object, out);
    }

    @Override
    public boolean willEncode(String propertyName, Object object) {
        return true;
    }

    protected boolean encodeId(String propertyName, Map<String, Object> id, JsonGenerator out) throws IOException {
        return this.isCompoundId ? this.encodeCompoundId(propertyName, id, this.valueEncoders, out) : this.encodeSingleId(propertyName, id, this.valueEncoder, out);
    }

    private boolean encodeSingleId(String propertyName, Map<String, Object> values, Encoder valueEncoder, JsonGenerator out) throws IOException {
        if (values.size() != 1) {
            throw new IllegalArgumentException("Can't serialize multi-value ObjectId: " + values);
        }
        Object value = values.entrySet().iterator().next().getValue();
        return valueEncoder.encode(propertyName, value, out);
    }

    private boolean encodeCompoundId(String propertyName, Map<String, Object> values, Map<String, Encoder> valueEncoders, JsonGenerator out) throws IOException {
        if (propertyName != null) {
            out.writeFieldName(propertyName);
        }
        out.writeStartObject();
        for (Map.Entry<String, Encoder> entry : valueEncoders.entrySet()) {
            Encoder valueEncoder = entry.getValue();
            Object value = values.get(entry.getKey());
            if (value == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Missing value for compound ID property: " + entry.getKey());
            }
            valueEncoder.encode(entry.getKey(), value, out);
        }
        out.writeEndObject();
        return true;
    }
}

