/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.AbstractEncoder;
import com.nhl.link.rest.encoder.Encoder;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ISOTimeEncoder
extends AbstractEncoder {
    private static final Encoder instance = new ISOTimeEncoder();
    private DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());

    public static Encoder encoder() {
        return instance;
    }

    private ISOTimeEncoder() {
    }

    @Override
    protected boolean encodeNonNullObject(Object object, JsonGenerator out) throws IOException {
        Date date = (Date)object;
        String formatted = this.format.format(Instant.ofEpochMilli(date.getTime()));
        out.writeObject((Object)formatted);
        return true;
    }
}

