/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderFilter;
import java.io.IOException;
import java.util.List;

public class FilterChainEncoder
implements Encoder {
    private Encoder delegate;
    private List<EncoderFilter> filters;

    public FilterChainEncoder(Encoder delegate, List<EncoderFilter> filters) {
        this.delegate = delegate;
        this.filters = filters;
    }

    @Override
    public boolean encode(String propertyName, Object object, JsonGenerator out) throws IOException {
        return new ChainEncoder().encode(propertyName, object, out);
    }

    @Override
    public boolean willEncode(String propertyName, Object object) {
        return new ChainEncoder().willEncode(propertyName, object);
    }

    private final class ChainEncoder
    implements Encoder {
        private int i;

        private ChainEncoder() {
        }

        EncoderFilter nextFilter() {
            EncoderFilter filter = this.i >= FilterChainEncoder.this.filters.size() ? null : (EncoderFilter)FilterChainEncoder.this.filters.get(this.i);
            ++this.i;
            return filter;
        }

        @Override
        public boolean encode(String propertyName, Object object, JsonGenerator out) throws IOException {
            EncoderFilter filter = this.nextFilter();
            if (filter != null) {
                return filter.encode(propertyName, object, out, this);
            }
            return FilterChainEncoder.this.delegate.encode(propertyName, object, out);
        }

        @Override
        public boolean willEncode(String propertyName, Object object) {
            EncoderFilter filter = this.nextFilter();
            if (filter != null) {
                return filter.willEncode(propertyName, object, this);
            }
            return FilterChainEncoder.this.delegate.willEncode(propertyName, object);
        }
    }
}

