/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.AbstractEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.PropertyMetadataEncoder;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class EntityMetadataEncoder
extends AbstractEncoder {
    private LrEntity<?> entity;
    private Map<String, PropertyMetadataEncoder> propertyMetadataEncoders;
    private Map<String, PropertyHelper> properties;

    public EntityMetadataEncoder(LrEntity<?> entity, Map<String, PropertyMetadataEncoder> propertyMetadataEncoders) {
        this.entity = entity;
        this.propertyMetadataEncoders = propertyMetadataEncoders;
        this.properties = new TreeMap<String, PropertyHelper>();
        for (LrAttribute attribute : entity.getAttributes()) {
            this.properties.put(attribute.getName(), new AttributeProperty(attribute));
        }
        for (LrRelationship relationship : entity.getRelationships()) {
            this.properties.put(relationship.getName(), new RelationshipProperty(relationship));
        }
    }

    @Override
    protected boolean encodeNonNullObject(Object object, JsonGenerator out) throws IOException {
        if (!this.entity.equals(object)) {
            throw new IllegalArgumentException("Expected entity: " + this.entity.getName() + ", was object of class: " + object.getClass().getName());
        }
        out.writeStartObject();
        out.writeStringField("name", this.entity.getName());
        out.writeArrayFieldStart("properties");
        for (Map.Entry<String, PropertyHelper> e : this.properties.entrySet()) {
            String typeName = byte[].class.equals(e.getValue().getType()) ? "byte[]" : e.getValue().getType().getName();
            Encoder encoder = this.propertyMetadataEncoders.get(typeName);
            if (encoder == null) {
                encoder = PropertyMetadataEncoder.encoder();
            }
            encoder.encode(null, e.getValue().getProperty(), out);
        }
        out.writeEndArray();
        out.writeEndObject();
        return true;
    }

    private static class RelationshipProperty
    extends PropertyHelper {
        private LrRelationship relationship;

        RelationshipProperty(LrRelationship relationship) {
            this.relationship = relationship;
        }

        @Override
        Class<?> getType() {
            return this.relationship.getTargetEntity().getType();
        }

        @Override
        Object getProperty() {
            return this.relationship;
        }
    }

    private static class AttributeProperty
    extends PropertyHelper {
        private LrAttribute attribute;

        AttributeProperty(LrAttribute attribute) {
            this.attribute = attribute;
        }

        @Override
        Class<?> getType() {
            return this.attribute.getType();
        }

        @Override
        Object getProperty() {
            return this.attribute;
        }
    }

    private static abstract class PropertyHelper {
        private PropertyHelper() {
        }

        abstract Class<?> getType();

        abstract Object getProperty();
    }
}

