/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderFilter;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import java.io.IOException;

public abstract class EntityEncoderFilter<T>
implements EncoderFilter {
    private LrEntity<T> lrEntity;

    public EntityEncoderFilter(IMetadataService metadataService) {
        this.lrEntity = metadataService.getLrEntity(this.getType());
    }

    protected abstract Class<T> getType();

    protected abstract boolean willEncode(T var1);

    @Override
    public boolean matches(ResourceEntity<?> resourceEntity) {
        return this.lrEntity == resourceEntity.getLrEntity();
    }

    @Override
    public boolean encode(String propertyName, Object object, JsonGenerator out, Encoder delegate) throws IOException {
        if (this.willEncode(object)) {
            return delegate.encode(propertyName, object, out);
        }
        return false;
    }

    @Override
    public boolean willEncode(String propertyName, Object object, Encoder delegate) {
        return this.willEncode(object);
    }
}

