/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.encoder.AbstractEncoder;
import com.nhl.link.rest.encoder.EncoderVisitor;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class EntityEncoder
extends AbstractEncoder {
    private EntityProperty idEncoder;
    private Map<String, EntityProperty> relationshipEncoders;
    private Map<String, EntityProperty> combinedEncoders;

    public EntityEncoder(EntityProperty idEncoder, Map<String, EntityProperty> attributeEncoders, Map<String, EntityProperty> relationshipEncoders, Map<String, EntityProperty> extraEncoders) {
        this.idEncoder = idEncoder;
        this.relationshipEncoders = relationshipEncoders;
        this.combinedEncoders = new TreeMap<String, EntityProperty>();
        this.combinedEncoders.putAll(attributeEncoders);
        this.combinedEncoders.putAll(relationshipEncoders);
        this.combinedEncoders.putAll(extraEncoders);
    }

    @Override
    protected boolean encodeNonNullObject(Object object, JsonGenerator out) throws IOException {
        out.writeStartObject();
        this.idEncoder.encode(object, "id", out);
        for (Map.Entry<String, EntityProperty> e : this.combinedEncoders.entrySet()) {
            e.getValue().encode(object, e.getKey(), out);
        }
        out.writeEndObject();
        return true;
    }

    @Override
    public int visitEntities(Object object, EncoderVisitor visitor) {
        if (object == null || !this.willEncode(null, object)) {
            return 0;
        }
        int bitmask = visitor.visit(object);
        if ((bitmask & 2) != 0) {
            return 2;
        }
        if ((bitmask & 1) == 0) {
            for (Map.Entry<String, EntityProperty> e : this.relationshipEncoders.entrySet()) {
                visitor.push(e.getKey());
                int propBitmask = e.getValue().visit(object, e.getKey(), visitor);
                if ((propBitmask & 2) != 0) {
                    return 2;
                }
                visitor.pop();
            }
        }
        return 0;
    }
}

