/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.encoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.encoder.CollectionEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderVisitor;
import java.io.IOException;

public class DataResponseEncoder
implements Encoder {
    private CollectionEncoder resultEncoder;
    private Encoder totalEncoder;
    private String resultProperty;
    private String totalProperty;

    public DataResponseEncoder(String resultProperty, CollectionEncoder resultEncoder, String totalProperty, Encoder totalEncoder) {
        this.totalProperty = totalProperty;
        this.resultEncoder = resultEncoder;
        this.totalEncoder = totalEncoder;
        this.resultProperty = resultProperty;
    }

    @Override
    public boolean encode(String propertyName, Object object, JsonGenerator out) throws IOException {
        if (propertyName != null) {
            out.writeFieldName(propertyName);
        }
        out.writeStartObject();
        this.encodeObjectBody(object, out);
        out.writeEndObject();
        return true;
    }

    protected void encodeObjectBody(Object object, JsonGenerator out) throws IOException {
        int count = this.resultEncoder.encodeAndGetTotal(this.resultProperty, object, out);
        this.totalEncoder.encode(this.totalProperty, count, out);
    }

    @Override
    public boolean willEncode(String propertyName, Object object) {
        return true;
    }

    @Override
    public int visitEntities(Object object, EncoderVisitor visitor) {
        return this.resultEncoder.visitEntities(object, visitor);
    }
}

