/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.constraints;

import com.nhl.link.rest.constraints.ConstrainedLrEntity;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import java.util.List;
import java.util.function.Function;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.Property;

public class ConstraintsBuilder<T>
implements Constraint<T> {
    protected Function<ConstrainedLrEntity<T>, ConstrainedLrEntity<T>> op;

    protected ConstraintsBuilder(Function<ConstrainedLrEntity<T>, ConstrainedLrEntity<T>> op) {
        this.op = op;
    }

    public static <T> ConstraintsBuilder<T> excludeAll(Class<T> type) {
        return Constraint.excludeAll(type);
    }

    public static <T> ConstraintsBuilder<T> idOnly(Class<T> type) {
        return Constraint.idOnly(type);
    }

    public static <T> ConstraintsBuilder<T> idAndAttributes(Class<T> type) {
        return Constraint.idAndAttributes(type);
    }

    @Override
    public ConstrainedLrEntity<T> apply(LrEntity<T> lrEntity) {
        return this.op.apply(new ConstrainedLrEntity<T>(lrEntity));
    }

    public ConstraintsBuilder<T> excludeProperty(String attributeOrRelationship) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.excludeProperties(attributeOrRelationship);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> excludeProperty(Property<?> attributeOrRelationship) {
        return this.excludeProperty(attributeOrRelationship.getName());
    }

    public ConstraintsBuilder<T> excludeProperties(String ... attributesOrRelationships) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.excludeProperties(attributesOrRelationships);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> excludeProperties(Property<?> ... attributesOrRelationships) {
        String[] names = new String[attributesOrRelationships.length];
        for (int i = 0; i < attributesOrRelationships.length; ++i) {
            names[i] = attributesOrRelationships[i].getName();
        }
        return this.excludeProperties(names);
    }

    public ConstraintsBuilder<T> excludeAllAttributes() {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.excludeAllAttributes();
            return ce;
        }));
    }

    public ConstraintsBuilder<T> excludeAllChildren() {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.excludeAllChildren();
            return ce;
        }));
    }

    public ConstraintsBuilder<T> attribute(String attribute) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.includeAttributes(attribute);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> attribute(Property<?> attribute) {
        return this.attribute(attribute.getName());
    }

    public ConstraintsBuilder<T> allAttributes() {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.includeAllAttributes();
            return ce;
        }));
    }

    public ConstraintsBuilder<T> attributes(String ... attributes) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.includeAttributes(attributes);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> attributes(Property<?> ... attributes) {
        String[] names = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            names[i] = attributes[i].getName();
        }
        return this.attributes(names);
    }

    public ConstraintsBuilder<T> includeId(boolean include) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.includeId(include);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> includeId() {
        return this.includeId(true);
    }

    public ConstraintsBuilder<T> excludeId() {
        return this.includeId(false);
    }

    public ConstraintsBuilder<T> and(Expression qualifier) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.andQualifier(qualifier);
            return ce;
        }));
    }

    public ConstraintsBuilder<T> or(Expression qualifier) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            ce.orQualifier(qualifier);
            return ce;
        }));
    }

    public <S> ConstraintsBuilder<T> path(Property<S> path, ConstraintsBuilder<S> subentityBuilder) {
        return this.path(path.getName(), subentityBuilder);
    }

    public <S> ConstraintsBuilder<T> toManyPath(Property<List<S>> path, ConstraintsBuilder<S> subentityBuilder) {
        return this.path(path.getName(), subentityBuilder);
    }

    public <S> ConstraintsBuilder<T> path(String path, ConstraintsBuilder<S> subEntityBuilder) {
        return new ConstraintsBuilder<T>(this.op.andThen(ce -> {
            subEntityBuilder.op.apply(this.getOrCreateChild((ConstrainedLrEntity)ce, path));
            return ce;
        }));
    }

    private <P, C> ConstrainedLrEntity<C> getOrCreateChild(ConstrainedLrEntity<P> parent, String path) {
        int dot = path.indexOf(46);
        if (dot == 0) {
            throw new IllegalArgumentException("Invalid path, starts with dot: " + path);
        }
        if (dot == path.length() - 1) {
            throw new IllegalArgumentException("Invalid path, ends with dot: " + path);
        }
        String pathSegment = dot > 0 ? path.substring(0, dot) : path;
        LrRelationship relationship = parent.getEntity().getRelationship(pathSegment);
        if (relationship == null) {
            throw new IllegalArgumentException("Path contains non-relationship component: " + pathSegment);
        }
        ConstrainedLrEntity child = parent.getChild(relationship.getName());
        if (child == null) {
            LrEntity<?> targetEntity = relationship.getTargetEntity();
            child = new ConstrainedLrEntity(targetEntity);
            parent.getChildren().put(relationship.getName(), child);
        }
        return dot < 0 ? child : this.getOrCreateChild(child, path.substring(dot + 1));
    }
}

