/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.constraints;

import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.exp.Expression;

public class ConstrainedLrEntity<T> {
    private boolean idIncluded;
    private Collection<String> attributes;
    private Map<String, ConstrainedLrEntity<?>> children;
    private Expression qualifier;
    private LrEntity<T> entity;

    public ConstrainedLrEntity(LrEntity<T> entity) {
        if (entity == null) {
            throw new NullPointerException("Null entity");
        }
        this.idIncluded = false;
        this.entity = entity;
        this.children = new HashMap();
        this.attributes = new HashSet<String>();
    }

    Collection<String> getAttributes() {
        return this.attributes;
    }

    Map<String, ConstrainedLrEntity<?>> getChildren() {
        return this.children;
    }

    public LrEntity<T> getEntity() {
        return this.entity;
    }

    public boolean isIdIncluded() {
        return this.idIncluded;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.contains(name);
    }

    public ConstrainedLrEntity getChild(String name) {
        return this.children.get(name);
    }

    public boolean hasChild(String name) {
        return this.children.containsKey(name);
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    void excludeProperties(String ... attributesOrRelationships) {
        if (attributesOrRelationships != null) {
            for (String name : attributesOrRelationships) {
                if (this.attributes.remove(name)) continue;
                this.children.remove(name);
            }
        }
    }

    void excludeAllAttributes() {
        this.attributes.clear();
    }

    void excludeAllChildren() {
        this.children.clear();
    }

    void includeAttributes(String ... attributes) {
        if (attributes != null) {
            for (String a : attributes) {
                this.attributes.add(a);
            }
        }
    }

    public void includeAllAttributes() {
        for (LrAttribute a : this.entity.getAttributes()) {
            this.attributes.add(a.getName());
        }
    }

    void includeId(boolean include) {
        this.idIncluded = include;
    }

    void andQualifier(Expression qualifier) {
        this.qualifier = this.qualifier == null ? qualifier : this.qualifier.andExp(qualifier);
    }

    void orQualifier(Expression qualifier) {
        this.qualifier = this.qualifier == null ? qualifier : this.qualifier.orExp(qualifier);
    }
}

