/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.util.ToStringBuilder;

public class ResourceEntity<T> {
    private boolean idIncluded = false;
    private LrEntity<T> lrEntity;
    private Map<String, LrAttribute> attributes = new HashMap<String, LrAttribute>();
    private Collection<String> defaultProperties = new HashSet<String>();
    private String applicationBase;
    private String mapByPath;
    private ResourceEntity<?> mapBy;
    private Map<String, ResourceEntity<?>> children = new HashMap();
    private LrRelationship incoming;
    private Collection<Ordering> orderings = new ArrayList<Ordering>(2);
    private Expression qualifier;
    private Map<String, EntityProperty> extraProperties = new HashMap<String, EntityProperty>();
    private int fetchOffset;
    private int fetchLimit;
    private boolean filtered;

    public ResourceEntity(LrEntity<T> lrEntity) {
        this.lrEntity = lrEntity;
    }

    public ResourceEntity(LrEntity<T> lrEntity, LrRelationship incoming) {
        this(lrEntity);
        this.incoming = incoming;
    }

    public LrEntity<T> getLrEntity() {
        return this.lrEntity;
    }

    public LrRelationship getIncoming() {
        return this.incoming;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public void andQualifier(Expression qualifier) {
        this.qualifier = this.qualifier == null ? qualifier : this.qualifier.andExp(qualifier);
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public Map<String, LrAttribute> getAttributes() {
        return this.attributes;
    }

    public Collection<String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean isDefault(String propertyName) {
        return this.defaultProperties.contains(propertyName);
    }

    public Map<String, ResourceEntity<?>> getChildren() {
        return this.children;
    }

    public ResourceEntity<?> getChild(String name) {
        return this.children.get(name);
    }

    public Map<String, EntityProperty> getExtraProperties() {
        return this.extraProperties;
    }

    public boolean isIdIncluded() {
        return this.idIncluded;
    }

    public ResourceEntity<T> includeId(boolean include) {
        this.idIncluded = include;
        return this;
    }

    public ResourceEntity<T> includeId() {
        this.idIncluded = true;
        return this;
    }

    public ResourceEntity<T> excludeId() {
        this.idIncluded = false;
        return this;
    }

    public ResourceEntity<?> getMapBy() {
        return this.mapBy;
    }

    public ResourceEntity<T> mapBy(ResourceEntity<?> mapBy, String mapByPath) {
        this.mapByPath = mapByPath;
        this.mapBy = mapBy;
        return this;
    }

    public String getMapByPath() {
        return this.mapByPath;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        if (this.lrEntity != null) {
            tsb.append("name", (Object)this.lrEntity.getName());
        }
        return tsb.toString();
    }

    public Class<T> getType() {
        return this.lrEntity.getType();
    }

    public int getFetchOffset() {
        return this.fetchOffset;
    }

    public void setFetchOffset(int fetchOffset) {
        this.fetchOffset = fetchOffset;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    public String getApplicationBase() {
        return this.applicationBase;
    }

    public void setApplicationBase(String applicationBase) {
        this.applicationBase = applicationBase;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }
}

