/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.nhl.link.rest.meta.LrEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityUpdate<T> {
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, Set<Object>> relatedIds = new HashMap<String, Set<Object>>();
    private Map<String, Object> id;
    private boolean explicitId;
    private Object mergedTo;
    private LrEntity<T> entity;

    public EntityUpdate(LrEntity<T> entity) {
        this.entity = entity;
    }

    public LrEntity<T> getEntity() {
        return this.entity;
    }

    public boolean hasChanges() {
        return !this.values.isEmpty() || !this.relatedIds.isEmpty();
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Map<String, Set<Object>> getRelatedIds() {
        return this.relatedIds;
    }

    public void addRelatedId(String relationshipName, Object value) {
        Set<Object> values = this.relatedIds.get(relationshipName);
        if (values == null) {
            values = new HashSet<Object>();
            this.relatedIds.put(relationshipName, values);
        }
        values.add(value);
    }

    public Map<String, Object> getId() {
        return this.id;
    }

    public Map<String, Object> getOrCreateId() {
        if (this.id == null) {
            this.id = new HashMap<String, Object>();
        }
        return this.id;
    }

    public void setExplicitId() {
        this.explicitId = true;
    }

    public boolean isExplicitId() {
        return this.explicitId;
    }

    public Object getMergedTo() {
        return this.mergedTo;
    }

    public void setMergedTo(Object mergedTo) {
        this.mergedTo = mergedTo;
    }
}

