/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.nhl.link.rest.CompoundObjectId;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.SimpleObjectId;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public class EntityParent<P> {
    private Class<P> type;
    private LrObjectId id;
    private String relationship;

    public EntityParent(Class<P> parentType, Map<String, Object> parentIds, String relationshipFromParent) {
        this(parentType, relationshipFromParent);
        if (parentIds == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Related parent ID is missing");
        }
        this.id = new CompoundObjectId(parentIds);
    }

    public EntityParent(Class<P> parentType, Object parentId, String relationshipFromParent) {
        this(parentType, relationshipFromParent);
        if (parentId == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Related parent ID is missing");
        }
        this.id = new SimpleObjectId(parentId);
    }

    public EntityParent(Class<P> parentType, String relationshipFromParent) {
        if (parentType == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Related parent type is missing");
        }
        if (relationshipFromParent == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Related parent relationship is missing");
        }
        this.type = parentType;
        this.relationship = relationshipFromParent;
    }

    public Class<P> getType() {
        return this.type;
    }

    public LrObjectId getId() {
        return this.id;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public Expression qualifier(EntityResolver resolver) {
        ObjEntity parentEntity = resolver.getObjEntity(this.type);
        ObjRelationship objRelationship = parentEntity.getRelationship(this.relationship);
        if (objRelationship == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid relationship: '" + this.relationship + "'");
        }
        if (this.id.size() > 1) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (DbRelationship dbRelationship : objRelationship.getDbRelationships()) {
                DbRelationship reverseRelationship = dbRelationship.getReverseRelationship();
                for (DbJoin join : reverseRelationship.getJoins()) {
                    Object joinValue = this.id.get(join.getTargetName());
                    if (joinValue == null) {
                        throw new LinkRestException(Response.Status.BAD_REQUEST, "Failed to build a Cayenne qualifier for a by-parent relationship '" + this.relationship + "'; one of the parent's ID parts is missing in it's ID: " + join.getTargetName());
                    }
                    expressions.add(ExpressionFactory.matchDbExp((String)join.getSourceName(), (Object)joinValue));
                }
            }
            return ExpressionFactory.and(expressions);
        }
        return ExpressionFactory.matchDbExp((String)objRelationship.getReverseDbRelationshipPath(), (Object)this.id.get());
    }
}

