/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.nhl.link.rest.encoder.EncoderVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.regex.Pattern;

class DataResponseFlattenExtractor<U>
implements EncoderVisitor {
    private static final Pattern SPLIT_PATH = Pattern.compile("\\.");
    private Collection<U> result;
    private String[] path;
    private Deque<String> stack;
    private State state;

    public DataResponseFlattenExtractor(String path) {
        this.path = path == null || path.length() == 0 ? new String[]{} : SPLIT_PATH.split(path);
        this.result = new ArrayList<U>();
        this.state = path.length() > 0 ? State.matching : State.collecting;
        this.stack = new ArrayDeque<String>();
    }

    public Collection<U> getResult() {
        return this.result;
    }

    @Override
    public int visit(Object object) {
        switch (this.state) {
            case matching: {
                return 0;
            }
            case collecting: {
                this.result.add(object);
                return 1;
            }
            case invalid: {
                return 1;
            }
        }
        return 1;
    }

    @Override
    public void push(String relationship) {
        this.stack.push(relationship);
        switch (this.state) {
            case matching: {
                if (this.path[this.stack.size() - 1].equals(relationship)) {
                    if (this.path.length != this.stack.size()) break;
                    this.state = State.collecting;
                    break;
                }
                this.state = State.invalid;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state on push: " + (Object)((Object)this.state));
            }
        }
    }

    @Override
    public void pop() {
        this.stack.pop();
        switch (this.state) {
            case collecting: {
                this.state = State.matching;
                break;
            }
        }
    }

    static enum State {
        matching,
        collecting,
        invalid;

    }
}

