/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.DataResponseFlattenExtractor;
import com.nhl.link.rest.LrResponse;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.GenericEncoder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DataResponse<T>
extends LrResponse {
    private Class<T> type;
    private List objects;
    private Encoder encoder;

    public static <T> DataResponse<T> forObject(T object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        return DataResponse.forObjects(Collections.singletonList(object));
    }

    public static <T> DataResponse<T> forObjects(List<T> objects) {
        if (objects.isEmpty()) {
            return new DataResponse<Object>(Object.class);
        }
        Class<?> type = objects.get(0).getClass();
        DataResponse response = new DataResponse(type);
        response.setObjects(objects);
        return response;
    }

    public static <T> DataResponse<T> forType(Class<T> type) {
        return new DataResponse<T>(type);
    }

    DataResponse(Class<T> type) {
        this.type = type;
        this.encoder = GenericEncoder.encoder();
        this.objects = Collections.emptyList();
    }

    public Class<T> getType() {
        return this.type;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setObjects(List<? extends T> objects) {
        this.objects = objects;
    }

    public void setObject(T object) {
        this.setObjects(Collections.singletonList(object));
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public Collection<T> getIncludedObjects() {
        return this.getIncludedObjects(this.getType(), "");
    }

    public <U> Collection<U> getIncludedObjects(Class<U> type, String path) {
        DataResponseFlattenExtractor extractor = new DataResponseFlattenExtractor(path);
        this.encoder.visitEntities(this.objects, extractor);
        return extractor.getResult();
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void writeData(JsonGenerator out) throws IOException {
        this.encoder.encode(null, this.getObjects(), out);
    }
}

