/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest;

import com.nhl.link.rest.BaseObjectId;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.parser.converter.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;

public class CompoundObjectId
extends BaseObjectId {
    private Map<String, Object> id;

    public CompoundObjectId(Map<String, Object> id) {
        this.id = id;
    }

    @Override
    public Object get(String attributeName) {
        return this.id.get(attributeName);
    }

    @Override
    public Object get() {
        return this.id;
    }

    @Override
    public int size() {
        return this.id.size();
    }

    @Override
    protected Map<String, Object> asMap(Collection<LrAttribute> idAttributes) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        for (LrAttribute idAttribute : idAttributes) {
            Object idValue = Normalizer.normalize(this.id.get(idAttribute.getName()), idAttribute.getType());
            if (idValue == null) {
                throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to build a compound ID: one of the entity's ID parts is missing in this ID object: " + idAttribute.getName());
            }
            if (idAttribute instanceof LrPersistentAttribute) {
                idMap.put(((LrPersistentAttribute)idAttribute).getColumnName(), idValue);
                continue;
            }
            idMap.put(idAttribute.getName(), idValue);
        }
        return idMap;
    }

    public String toString() {
        return CompoundObjectId.mapToString(this.id);
    }

    public static String mapToString(Map<String, Object> m) {
        StringBuilder buf = new StringBuilder("{");
        Iterator<Map.Entry<String, Object>> iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            buf.append(entry.getKey());
            buf.append(":");
            buf.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }
}

