/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.Collections;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;

public class JVMInformationMapper
implements EventToEvent {
    public static final String SIMPLE_CLASS_NAME = JVMInformationMapper.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.JVMInformation";
    public static final String JVM_START_TIME = "jvmStartTime";
    public static final String JVM_ARGUMENTS = "jvmArguments";
    public static final String JVM_VERSION = "jvmVersion";
    public static final String JFR_JVM_INFORMATION = "JfrJVMInformation";

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public List<Event> apply(RecordedEvent event) {
        long timestamp = event.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        if (RecordedObjectValidators.hasField(event, JVM_START_TIME, SIMPLE_CLASS_NAME)) {
            attr.put(JVM_START_TIME, event.getInstant(JVM_START_TIME).toEpochMilli());
        }
        if (RecordedObjectValidators.hasField(event, JVM_ARGUMENTS, SIMPLE_CLASS_NAME)) {
            attr.put(JVM_ARGUMENTS, event.getString(JVM_ARGUMENTS));
        }
        if (RecordedObjectValidators.hasField(event, JVM_VERSION, SIMPLE_CLASS_NAME)) {
            attr.put(JVM_VERSION, event.getString(JVM_VERSION));
        }
        return Collections.singletonList(new Event(JFR_JVM_INFORMATION, attr, timestamp));
    }
}

