/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.httpclient;

import com.newrelic.agent.deps.org.apache.http.HttpHost;
import com.newrelic.agent.deps.org.apache.http.auth.AuthScope;
import com.newrelic.agent.deps.org.apache.http.auth.Credentials;
import com.newrelic.agent.deps.org.apache.http.auth.UsernamePasswordCredentials;
import com.newrelic.agent.deps.org.apache.http.client.protocol.HttpClientContext;
import com.newrelic.agent.deps.org.apache.http.impl.client.BasicCredentialsProvider;
import com.newrelic.agent.deps.org.apache.http.protocol.HttpContext;
import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.DaemonConfig;
import java.text.MessageFormat;

public class ApacheProxyManager {
    private final HttpHost proxy;
    private final Credentials proxyCredentials;
    private static final Logger logger = LoggerFactory.getLogger(ApacheProxyManager.class);

    public ApacheProxyManager(DaemonConfig config) {
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        String proxyScheme = config.getProxyScheme();
        String proxyUser = config.getProxyUser();
        String proxyPassword = config.getProxyPassword();
        if (proxyHost != null && proxyPort != null && proxyScheme != null) {
            this.proxy = new HttpHost(proxyHost, (int)proxyPort, proxyScheme);
            this.proxyCredentials = this.getProxyCredentials(proxyUser, proxyPassword);
            logger.info("JFR HttpPoster: configured to use " + proxyScheme + " proxy: " + proxyHost + ":" + proxyPort);
        } else {
            this.proxy = null;
            this.proxyCredentials = null;
        }
    }

    private Credentials getProxyCredentials(String proxyUser, String proxyPass) {
        if (proxyUser != null && proxyPass != null) {
            logger.info(MessageFormat.format("JFR HttpPoster: Setting Proxy Authenticator for user {0}", proxyUser));
            return new UsernamePasswordCredentials(proxyUser, proxyPass);
        }
        return null;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public HttpContext updateContext(HttpClientContext httpClientContext) {
        if (this.proxy != null && this.proxyCredentials != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.proxy), this.proxyCredentials);
            httpClientContext.setCredentialsProvider(credentialsProvider);
        }
        return httpClientContext;
    }
}

