/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.superagent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.SuperAgentIntegrationConfig;
import com.newrelic.agent.superagent.SuperAgentHealthNoOpClient;
import com.newrelic.agent.superagent.SuperAgentIntegrationHealthClient;
import com.newrelic.agent.superagent.SuperAgentIntegrationHealthFileBasedClient;
import java.util.logging.Level;

public class SuperAgentIntegrationClientFactory {
    private static final SuperAgentIntegrationHealthClient NO_OP_INSTANCE = new SuperAgentHealthNoOpClient();

    public static SuperAgentIntegrationHealthClient createHealthClient(SuperAgentIntegrationConfig config) {
        SuperAgentIntegrationHealthClient client;
        try {
            HealthClientType healthClientType = HealthClientType.valueOf(config.getHealthClientType());
            Agent.LOG.log(Level.INFO, "Generating SuperAgent Health Client type: {0}", (Object)healthClientType);
            switch (healthClientType) {
                case file: {
                    client = new SuperAgentIntegrationHealthFileBasedClient(config);
                    break;
                }
                default: {
                    client = NO_OP_INSTANCE;
                    break;
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "Invalid health client type: {0}; returning NoOp implementation", config.getHealthClientType());
            client = NO_OP_INSTANCE;
        }
        return client;
    }

    public static enum HealthClientType {
        noop,
        file;

    }
}

