/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.service.module.ClassToJarPathSubmitter;
import com.newrelic.agent.service.module.JarAnalystFactory;
import com.newrelic.api.agent.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ClassToJarPathSubmitterImpl
implements ClassToJarPathSubmitter {
    public static final ClassToJarPathSubmitter NO_OP_INSTANCE = new NoOpClassToJarPathSubmitter();
    private final JarAnalystFactory jarAnalystFactory;
    private final ExecutorService executorService;
    private final Logger logger;
    private final Set<String> seenPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger classSeenCount = new AtomicInteger(0);

    public ClassToJarPathSubmitterImpl(JarAnalystFactory jarAnalystFactory, ExecutorService executorService, Logger logger) {
        this.jarAnalystFactory = jarAnalystFactory;
        this.executorService = executorService;
        this.logger = logger;
    }

    @Override
    public void processUrl(URL url) {
        if (url != null) {
            this.classSeenCount.incrementAndGet();
            try {
                this.addSingleURL(url);
            }
            catch (MalformedURLException exception) {
                this.logger.log(Level.FINEST, (Throwable)exception, "{0} unable to process url", (Object)url);
            }
        }
    }

    private void addSingleURL(URL url) throws MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            this.addJarProtocolURL(url);
        } else if (url.getFile().endsWith(".jar")) {
            this.addURLEndingWithJar(url);
        } else {
            this.addOtherURL(url);
        }
    }

    private void addOtherURL(URL url) throws MalformedURLException {
        String path;
        int jarIndex = url.getFile().lastIndexOf(".jar");
        if (jarIndex > 0 && this.seenPaths.add(path = url.getFile().substring(0, jarIndex + ".jar".length()))) {
            URL finalUrl = new URL(url.getProtocol(), url.getHost(), path);
            this.submitJarUrlForAnalysis(finalUrl);
        }
    }

    private void addJarProtocolURL(URL url) throws MalformedURLException {
        String path = url.getFile();
        int index = path.lastIndexOf(".jar");
        if (index > 0) {
            path = path.substring(0, index + ".jar".length());
        }
        if (this.seenPaths.add(path)) {
            this.submitJarUrlForAnalysis(new URL(path));
        }
    }

    private void addURLEndingWithJar(URL url) {
        if (this.seenPaths.add(url.getFile())) {
            this.submitJarUrlForAnalysis(url);
        }
    }

    private void submitJarUrlForAnalysis(URL finalUrl) {
        this.executorService.submit(this.jarAnalystFactory.createURLAnalyzer(finalUrl));
        this.logger.log(Level.FINEST, "{0} offered to analysis queue; {1} paths seen and {2} classes seen.", (Object)finalUrl, (Object)this.seenPaths.size(), (Object)this.classSeenCount.get());
    }

    private static class NoOpClassToJarPathSubmitter
    implements ClassToJarPathSubmitter {
        private NoOpClassToJarPathSubmitter() {
        }

        @Override
        public void processUrl(URL url) {
        }
    }
}

