/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.profile.v2.BaseTree;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.profile.v2.ProfileSegment;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import com.newrelic.agent.profile.v2.SimpleProfileSegment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileTree
extends BaseTree<SimpleProfileSegment> {
    private long cpuTime;
    private final boolean reportCpuTime;

    public ProfileTree(IProfile profile, boolean reportCpuTime) {
        super(profile);
        this.reportCpuTime = reportCpuTime;
    }

    private SimpleProfileSegment add(StackTraceElement stackTraceElement, SimpleProfileSegment parent, boolean runnable) {
        ProfiledMethod method = this.profile.getProfiledMethodFactory().getProfiledMethod(stackTraceElement);
        if (method == null) {
            return parent;
        }
        return this.add(method, parent, runnable);
    }

    public void addStackTrace(List<StackTraceElement> stackTraceList, boolean runnable) {
        SimpleProfileSegment parent = null;
        for (StackTraceElement methodCall : stackTraceList) {
            parent = this.add(methodCall, parent, runnable);
        }
    }

    @Override
    protected Map<String, Object> getExtraData() {
        if (this.reportCpuTime) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("cpu_time", this.cpuTime);
            return data;
        }
        return ImmutableMap.of();
    }

    ProfileSegment getSegmentForMethod(StackTraceElement stackTraceElement) {
        ProfiledMethod method = this.profile.getProfiledMethodFactory().getProfiledMethod(stackTraceElement);
        if (method == null) {
            return null;
        }
        return this.getSegment(method);
    }

    public void incrementCpuTime(long cpuTime) {
        this.cpuTime += cpuTime;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    protected SimpleProfileSegment createProfiledMethod(ProfiledMethod method) {
        return SimpleProfileSegment.newProfileSegment(method);
    }
}

