/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.stub;

import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.io.grpc.ExperimentalApi;
import com.newrelic.agent.deps.io.grpc.stub.CallStreamObserver;
import java.util.Iterator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
public final class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            private boolean completed;

            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                if (this.completed) {
                    return;
                }
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    this.completed = true;
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

