/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.SuperAgentIntegrationConfig;
import com.newrelic.agent.config.SuperAgentIntegrationHealthConfig;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class SuperAgentIntegrationConfigImpl
extends BaseConfig
implements SuperAgentIntegrationConfig {
    public static final String ROOT = "superagent";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.superagent.";
    public static final String FLEET_ID = "fleet_id";
    private final String fleetId;
    private final SuperAgentIntegrationHealthConfig superAgentIntegrationHealthConfig = this.createHealthConfig();

    public SuperAgentIntegrationConfigImpl(Map<String, Object> configProps) {
        super(configProps, SYSTEM_PROPERTY_ROOT);
        String tmpFleetId = (String)this.getProperty(FLEET_ID);
        if (StringUtils.isNotEmpty(tmpFleetId) && this.superAgentIntegrationHealthConfig.getHealthDeliveryLocation() == null) {
            Agent.LOG.log(Level.WARNING, "Configured Super Agent health delivery location is not a valid URI; SuperAgent integration service will not be started");
            this.fleetId = null;
        } else {
            this.fleetId = tmpFleetId;
        }
    }

    private SuperAgentIntegrationHealthConfig createHealthConfig() {
        Map<String, Object> healthProps = this.getProperty("health", Collections.emptyMap());
        SuperAgentIntegrationHealthConfig superAgentIntegrationHealthConfig = new SuperAgentIntegrationHealthConfig(healthProps, SYSTEM_PROPERTY_ROOT);
        return superAgentIntegrationHealthConfig;
    }

    @Override
    public boolean isEnabled() {
        return this.fleetId != null;
    }

    @Override
    public URI getHealthDeliveryLocation() {
        return this.superAgentIntegrationHealthConfig == null ? null : this.superAgentIntegrationHealthConfig.getHealthDeliveryLocation();
    }

    @Override
    public int getHealthReportingFrequency() {
        return this.superAgentIntegrationHealthConfig == null ? 0 : this.superAgentIntegrationHealthConfig.getHealthReportingFrequency();
    }

    @Override
    public String getFleetId() {
        return this.fleetId;
    }

    @Override
    public String getHealthClientType() {
        return this.superAgentIntegrationHealthConfig == null ? null : this.superAgentIntegrationHealthConfig.getHealthClientType();
    }
}

