/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Map;

public class SpanEventsConfig
extends BaseConfig {
    public static final int DEFAULT_MAX_SPAN_EVENTS_PER_HARVEST = 2000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;
    public static final boolean DEFAULT_CROSS_PROCESS_ONLY = false;
    public static final String COLLECT_SPAN_EVENTS = "collect_span_events";
    public static final String ENABLED = "enabled";
    public static final String MAX_SPAN_EVENTS_PER_HARVEST = "max_samples_stored";
    public static final String SERVER_SPAN_HARVEST_CONFIG = "span_event_harvest_config";
    public static final String SERVER_SPAN_HARVEST_LIMIT = "harvest_limit";
    private static final String ROOT = "newrelic.config.";
    private static final String SPAN_EVENTS = "span_events.";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.span_events.";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";
    private static final String CROSS_PROCESS_ONLY = "cross_process_only";
    private static final boolean DEFAULT_COLLECT_SPANS = false;
    private final boolean dtEnabled;
    private int maxSamplesStored;
    private final boolean enabled;
    private final int targetSamplesStored;
    private final boolean crossProcessOnly;

    public SpanEventsConfig(Map<String, Object> props, boolean dtEnabled) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.dtEnabled = dtEnabled;
        this.maxSamplesStored = this.getProperty(MAX_SPAN_EVENTS_PER_HARVEST, 2000);
        this.enabled = this.initEnabled(this.maxSamplesStored);
        this.targetSamplesStored = this.getProperty(TARGET_SAMPLES_STORED, 10);
        this.crossProcessOnly = this.getProperty(CROSS_PROCESS_ONLY, false);
    }

    private boolean initEnabled(int maxSamplesStored) {
        boolean configEnabled = this.getProperty(ENABLED, this.dtEnabled) != false && this.dtEnabled;
        boolean collectSpanEventsFromCollector = this.getProperty(COLLECT_SPAN_EVENTS, false);
        return maxSamplesStored > 0 && configEnabled && collectSpanEventsFromCollector;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public void setMaxSamplesStoredByServerProp(int harvestLimit) {
        this.maxSamplesStored = harvestLimit;
    }

    public int getTargetSamplesStored() {
        return this.targetSamplesStored;
    }

    public boolean isCrossProcessOnly() {
        return this.crossProcessOnly;
    }
}

