/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.regex;

import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.regex.RegularExpression;
import com.networknt.schema.regex.RegularExpressionFactory;
import java.util.function.Predicate;

public class AllowRegularExpressionFactory
implements RegularExpressionFactory {
    private final RegularExpressionFactory delegate;
    private final Predicate<String> allowed;

    public AllowRegularExpressionFactory(RegularExpressionFactory delegate, Predicate<String> allowed) {
        this.delegate = delegate;
        this.allowed = allowed;
    }

    @Override
    public RegularExpression getRegularExpression(String regex) {
        if (this.allowed.test(regex)) {
            return this.delegate.getRegularExpression(regex);
        }
        throw new InvalidSchemaException(((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Regular expression ''{1}'' is not allowed to be used.")).arguments(regex)).build());
    }
}

