/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Format;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.format.BaseFormatJsonValidator;
import java.util.Collections;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatValidator
extends BaseFormatJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format, ErrorMessageType errorMessageType, Keyword keyword) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, errorMessageType, keyword, validationContext);
        this.format = format;
    }

    public FormatValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format, ValidatorTypeCode type) {
        this(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, format, type, type);
    }

    protected Object getAnnotationValue() {
        if (this.format != null) {
            return this.format.getName();
        }
        return this.schemaNode.isTextual() ? this.schemaNode.textValue() : null;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        Object annotationValue;
        FormatValidator.debug(logger, node, rootNode, instanceLocation);
        if (this.collectAnnotations(executionContext) && (annotationValue = this.getAnnotationValue()) != null) {
            this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(annotationValue));
        }
        boolean assertionsEnabled = this.isAssertionsEnabled(executionContext);
        if (this.format != null) {
            try {
                return this.format.validate(executionContext, this.validationContext, node, rootNode, instanceLocation, assertionsEnabled, () -> (MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).messageKey(this.format.getMessageKey())).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast()), this);
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on {}: Invalid RE syntax [{}]", new Object[]{instanceLocation, this.format.getName(), pse});
                return Collections.emptySet();
            }
        }
        return this.validateUnknownFormat(executionContext, node, rootNode, instanceLocation);
    }

    protected Set<ValidationMessage> validateUnknownFormat(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (this.createUnknownFormatAssertions(executionContext) && this.schemaNode.isTextual()) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).instanceNode(node)).messageKey("format.unknown")).arguments(this.schemaNode.textValue())).build());
        }
        return Collections.emptySet();
    }

    protected boolean createUnknownFormatAssertions(ExecutionContext executionContext) {
        return this.isAssertionsEnabled(executionContext) && this.isStrict(executionContext) || this.isFormatAssertionVocabularyEnabled();
    }

    protected boolean isStrict(ExecutionContext executionContext) {
        return this.validationContext.getConfig().isStrict(this.getKeyword(), Boolean.FALSE);
    }
}

