/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.AtlasTimerBatchUpdater;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.impl.StepLong;
import com.netflix.spectator.impl.StepValue;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class AtlasTimer
extends AtlasMeter
implements Timer {
    private final StepLong count;
    private final StepDouble total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasTimer(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepDouble(0.0, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(new Tag[]{DsType.rate, Statistic.count}), id.withTags(new Tag[]{DsType.rate, Statistic.totalTime}), id.withTags(new Tag[]{DsType.rate, Statistic.totalOfSquares}), id.withTags(new Tag[]{DsType.gauge, Statistic.max})};
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        this.reportMeasurement(now, consumer, this.stats[0], (StepValue)this.count, 1.0);
        this.reportMeasurement(now, consumer, this.stats[1], (StepValue)this.total, 1.0E-9);
        this.reportMeasurement(now, consumer, this.stats[2], (StepValue)this.totalOfSquares, 1.0E-18);
        this.reportMaxMeasurement(now, consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(long now, MeasurementConsumer consumer, Id mid, StepValue v, double f) {
        double rate = v.pollAsRate(now) * f;
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(long now, MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = (double)v.poll(now) / 1.0E9;
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    public Clock clock() {
        return this.clock;
    }

    public void record(long amount, TimeUnit unit) {
        long now = this.clock.wallTime();
        this.count.getCurrent(now).incrementAndGet();
        if (amount > 0L) {
            long nanos = unit.toNanos(amount);
            this.total.getCurrent(now).addAndGet((double)nanos);
            this.totalOfSquares.getCurrent(now).addAndGet((double)nanos * (double)nanos);
            this.updateMax(this.max.getCurrent(now), nanos);
        }
        this.updateLastModTime(now);
    }

    public void record(long[] amounts, int n, TimeUnit unit) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        double accumulatedTotal = 0.0;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            long nanos = unit.toNanos(amounts[i]);
            if (nanos <= 0L) continue;
            accumulatedTotal += (double)nanos;
            accumulatedTotalOfSquares += (double)nanos * (double)nanos;
            accumulatedMax = Math.max(nanos, accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.getCurrent(now).addAndGet(limit);
        this.total.getCurrent(now).addAndGet(accumulatedTotal);
        this.totalOfSquares.getCurrent(now).addAndGet(accumulatedTotalOfSquares);
        this.updateMax(this.max.getCurrent(now), accumulatedMax);
        this.updateLastModTime(now);
    }

    public void record(Duration[] amounts, int n) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        double accumulatedTotal = 0.0;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            long nanos = amounts[i].toNanos();
            if (nanos <= 0L) continue;
            accumulatedTotal += (double)nanos;
            accumulatedTotalOfSquares += (double)nanos * (double)nanos;
            accumulatedMax = Math.max(nanos, accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.getCurrent(now).addAndGet(limit);
        this.total.getCurrent(now).addAndGet(accumulatedTotal);
        this.totalOfSquares.getCurrent(now).addAndGet(accumulatedTotalOfSquares);
        this.updateMax(this.max.getCurrent(now), accumulatedMax);
        this.updateLastModTime(now);
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    public long count() {
        return this.count.poll();
    }

    public long totalTime() {
        return (long)this.total.poll();
    }

    public Timer.BatchUpdater batchUpdater(int batchSize) {
        AtlasTimerBatchUpdater updater = new AtlasTimerBatchUpdater(batchSize);
        updater.accept(() -> this);
        return updater;
    }

    void update(long count, double total, double totalOfSquares, long max) {
        long now = this.clock.wallTime();
        this.count.getCurrent(now).addAndGet(count);
        this.total.getCurrent(now).addAndGet(total);
        this.totalOfSquares.getCurrent(now).addAndGet(totalOfSquares);
        this.updateMax(this.max.getCurrent(now), max);
    }
}

